/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms;

import de.riwagis.dms.DMSCreator;
import de.riwagis.dms.DMSException;
import de.riwagis.dms.DMSInterface;
import de.riwagis.dms.DMSSupport;
import de.riwagis.dms.i18n.I18N;
import de.riwagis.dms.interfaces.DMSInterfaceImplFilesystem;
import de.riwagis.dms.interfaces.DMSInterfaceImplGenericInterface;
import de.riwagis.dms.interfaces.DMSInterfaceImplKiC;
import de.riwagis.dms.interfaces.DMSInterfaceImplMsgBox;
import de.riwagis.dms.interfaces.DMSInterfaceImplSocket;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public enum KnownDMSInterface {
    DMS_NONE("None", DMSSupport.DMSCREATOR_NONE, "NONE!"),
    DMS_MSGBOX("MsgBox", DMSInterfaceImplMsgBox.DMSCREATOR_MSGBOX, I18N.getString("de.riwagis.dms.interface.titleMsgBox")),
    DMS_KIC("KiC", DMSInterfaceImplKiC.DMSCREATOR_KIC, I18N.getString("de.riwagis.dms.interface.titleKomunaRis")),
    DMS_FILESYSTEM("Filesystem", DMSInterfaceImplFilesystem.DMSCREATOR_FILESYSTEM, I18N.getString("de.riwagis.dms.interface.titleFileSystem")),
    DMS_SOCKET("Socket", DMSInterfaceImplSocket.DMSCREATOR, I18N.getString("de.riwagis.dms.interface.titleSocket")),
    DMS_GENERICINTERFACE("GenericInterface", DMSInterfaceImplGenericInterface.DMSCREATOR_GENERICINTERFACE, I18N.getString("de.riwagis.dms.interface.titleGenericInterface"));

    private final String dmsID;
    private final DMSCreator creator;
    private final String name;

    private KnownDMSInterface(String dmsID, DMSCreator creator, String name) {
        if (dmsID == null || creator == null) {
            throw new NullPointerException(I18N.getString("de.riwagis.dms.interface.errorNullValue"));
        }
        this.dmsID = dmsID;
        this.creator = creator;
        this.name = name;
    }

    public String getDMSID() {
        return this.dmsID;
    }

    public String getName() {
        return this.name;
    }

    public static KnownDMSInterface getByDMSID(String configuredDMSID) {
        return KnownDMSInterface.getByDMSID(configuredDMSID, DMS_MSGBOX);
    }

    public static KnownDMSInterface getByDMSID(String configuredDMSID, KnownDMSInterface defaultValue) {
        for (KnownDMSInterface currInterface : KnownDMSInterface.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)configuredDMSID, (CharSequence)currInterface.getDMSID())) continue;
            return currInterface;
        }
        return defaultValue;
    }

    public DMSInterface create(Properties configuration) throws DMSException {
        return this.creator.create(configuration);
    }
}

