/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms;

import de.riwagis.dms.DMSCreator;
import de.riwagis.dms.DMSDocument;
import de.riwagis.dms.DMSException;
import de.riwagis.dms.DMSInterface;
import de.riwagis.dms.KnownDMSInterface;
import de.riwagis.dms.i18n.I18N;
import de.riwagis.dms.util.PropertyUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class DMSSupport {
    public static final String DMSCONFIG_USER = "riwawebgisdms_user.xml";
    public static final String DMSCONFIG_GLOBAL = "riwawebgisdms.xml";
    public static final String CFG_DMSID = "dmsid";
    public static final DMSCreator DMSCREATOR_NONE = configuration -> null;

    private DMSSupport() {
    }

    static String buildOriginKey(Integer moduleKey, Integer dialogKey, Integer fieldKey) {
        ArrayList<Integer> parts = new ArrayList<Integer>();
        for (Integer currPart : new Integer[]{moduleKey, dialogKey, fieldKey}) {
            if (currPart == null) continue;
            parts.add(currPart);
        }
        return StringUtils.join(parts, (String)".");
    }

    public static DMSInterface createCurrentDMS(File configDir, File configDirUser) throws DMSException {
        Properties configAll;
        try {
            configAll = DMSSupport.readDMSConfig(configDir, configDirUser);
        }
        catch (IOException ex) {
            throw new DMSException(I18N.format("de.riwagis.dms.ERROR_READCONFIG", ex.getMessage()), ex);
        }
        String configuredDMSID = configAll.getProperty(CFG_DMSID, KnownDMSInterface.DMS_MSGBOX.getDMSID());
        KnownDMSInterface dmsCreator = KnownDMSInterface.getByDMSID(configuredDMSID);
        return dmsCreator != KnownDMSInterface.DMS_NONE ? dmsCreator.create(configAll) : null;
    }

    public static Properties readDMSConfig(File configDir, File configDirUser) throws IOException {
        Properties configAll = PropertyUtils.joinConfig(PropertyUtils.readConfig(new File(configDir, DMSCONFIG_GLOBAL)), PropertyUtils.readConfig(new File(configDirUser, DMSCONFIG_USER)));
        return configAll;
    }

    public static boolean isLinkedToDMS(String webgisURI) {
        return DMSDocument.parseURI(webgisURI) != null;
    }

    public static List<String> buildOriginKeyAlternatives(String originKey) {
        ArrayList<String> res = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)originKey)) {
            String[] parts = originKey.split("\\.");
            for (int i = 0; i < parts.length; ++i) {
                res.add(StringUtils.join((Object[])Arrays.copyOfRange(parts, 0, parts.length - i), (String)"."));
            }
        }
        return res;
    }
}

