/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms;

import de.riwagis.dms.DMSDocumentDesc;
import de.riwagis.dms.HasDMSId;
import de.riwagis.dms.KnownDMSInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMSDocument
implements HasDMSId {
    private static final Logger LOG = LoggerFactory.getLogger(DMSDocument.class);
    public static final String PAR_DOCUMENT_NAME = "name";
    public static final String PAR_ORIGINKEY = "originkey";
    public static final String PROTOCOL_RIWADMS = "dms";
    public static final Charset URICHARSET = StandardCharsets.UTF_8;
    private final String dmsType;
    private final DMSDocumentDesc id;
    private final String originKey;

    public DMSDocument(String dmsType, DMSDocumentDesc desc, String originKey) {
        this.dmsType = dmsType;
        this.id = desc;
        this.originKey = originKey;
    }

    public DMSDocument(KnownDMSInterface dmsType, DMSDocumentDesc desc, String originKey) {
        this(dmsType.getDMSID(), desc, originKey);
    }

    public DMSDocument(KnownDMSInterface dmsType, String id, String documentName, String originKey) {
        this(dmsType.getDMSID(), id, documentName, originKey);
    }

    public DMSDocument(String dmsType, String id, String documentName, String originKey) {
        this(dmsType, new DMSDocumentDesc(id, documentName), originKey);
    }

    @Override
    public String getId() {
        return this.id.getId();
    }

    public String getDocumentName() {
        return this.id.getDocumentName();
    }

    public String getDmsType() {
        return this.dmsType;
    }

    public String getOriginKey() {
        return this.originKey;
    }

    public String buildURI() {
        ArrayList<BasicNameValuePair> nvp = new ArrayList<BasicNameValuePair>();
        nvp.add(new BasicNameValuePair(PAR_DOCUMENT_NAME, this.getDocumentName()));
        if (StringUtils.isNotBlank((CharSequence)this.getOriginKey())) {
            nvp.add(new BasicNameValuePair(PAR_ORIGINKEY, this.getOriginKey()));
        }
        try {
            URI res = new URI(PROTOCOL_RIWADMS, this.getDmsType(), "/" + this.getId(), URLEncodedUtils.format(nvp, (Charset)URICHARSET), null);
            return res.toString();
        }
        catch (URISyntaxException urisyx) {
            LOG.error(String.format("unable to build uri: %s", urisyx), (Throwable)urisyx);
            return null;
        }
    }

    public static final DMSDocument parseURI(String uriString) {
        if (StringUtils.isNotBlank((CharSequence)uriString)) {
            try {
                URI uriX = new URI(uriString);
                if (uriX.getScheme() != null && uriX.getScheme().equals(PROTOCOL_RIWADMS)) {
                    String documentId = StringUtils.stripStart((String)uriX.getPath(), (String)"/");
                    String dmsType = uriX.getAuthority();
                    List n = URLEncodedUtils.parse((String)uriX.getQuery(), (Charset)URICHARSET);
                    String documentName = DMSDocument.readParameter(n, PAR_DOCUMENT_NAME);
                    String originKey = DMSDocument.readParameter(n, PAR_ORIGINKEY, "");
                    KnownDMSInterface dmsTypeI = KnownDMSInterface.getByDMSID(dmsType, KnownDMSInterface.DMS_NONE);
                    return new DMSDocument(dmsTypeI, documentId, documentName, originKey);
                }
            }
            catch (URISyntaxException usix) {
                LOG.debug(String.format("unable to parse uri: %s", usix.getMessage()), (Throwable)usix);
            }
        }
        return null;
    }

    public static String readParameter(Collection<NameValuePair> parameters, String paramName) {
        return DMSDocument.readParameter(parameters, paramName, null);
    }

    public static String readParameter(Collection<NameValuePair> parameters, String paramName, String defaultValue) {
        for (NameValuePair currParm : parameters) {
            if (!StringUtils.equals((CharSequence)currParm.getName(), (CharSequence)paramName)) continue;
            return currParm.getValue();
        }
        return defaultValue;
    }

    public String toString() {
        return String.format("%s (%s, %s, %s)", this.getDocumentName(), this.getId(), this.originKey, this.dmsType);
    }
}

