/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.ByteArrayInputStream;
import java.util.Base64;

public class ByteArrayInputStreamConverter
implements Converter {
    public boolean canConvert(Class clazz) {
        return ByteArrayInputStream.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (value != null && value instanceof ByteArrayInputStream) {
            String s;
            int len;
            ByteArrayInputStream is = (ByteArrayInputStream)value;
            try {
                len = is.available();
                s = Base64.getMimeEncoder().encodeToString(is.readAllBytes());
            }
            finally {
                is.reset();
            }
            writer.startNode("buf");
            writer.setValue(s);
            writer.endNode();
            writer.startNode("pos");
            writer.setValue("0");
            writer.endNode();
            writer.startNode("mark");
            writer.setValue("0");
            writer.endNode();
            writer.startNode("count");
            writer.setValue(String.format("%d", len));
            writer.endNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.getMimeDecoder().decode(reader.getValue()));
            return byteArrayInputStream;
        }
        finally {
            reader.moveUp();
        }
    }
}

