/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import de.riwagis.util.xstream.Assert;
import java.awt.Point;

public class AWTPointConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Point p = (Point)source;
        writer.startNode("x");
        writer.setValue(Integer.toString(p.x));
        writer.endNode();
        writer.startNode("y");
        writer.setValue(Integer.toString(p.y));
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        Assert.assertNode(reader, "x");
        int x = Integer.parseInt(reader.getValue());
        reader.moveUp();
        reader.moveDown();
        Assert.assertNode(reader, "y");
        int y = Integer.parseInt(reader.getValue());
        reader.moveUp();
        return new Point(x, y);
    }

    public boolean canConvert(Class type) {
        return type.equals(Point.class);
    }
}

