/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import de.riwagis.util.xstream.Assert;
import java.awt.Dimension;

public class AWTDimensionConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Dimension p = (Dimension)source;
        writer.startNode("width");
        writer.setValue(Integer.toString(p.width));
        writer.endNode();
        writer.startNode("height");
        writer.setValue(Integer.toString(p.height));
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        Assert.assertNode(reader, "width");
        int x = Integer.parseInt(reader.getValue());
        reader.moveUp();
        reader.moveDown();
        Assert.assertNode(reader, "height");
        int y = Integer.parseInt(reader.getValue());
        reader.moveUp();
        return new Dimension(x, y);
    }

    public boolean canConvert(Class type) {
        return type.equals(Dimension.class);
    }
}

