/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import it.geosolutions.imageio.plugins.cog.CogImageReadParam;
import it.geosolutions.imageioimpl.plugins.cog.CogImageInputStream;
import it.geosolutions.imageioimpl.plugins.cog.CogTileInfo;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.PlanarImage;

public class CogImageReader
extends TIFFImageReader {
    private static final Logger LOGGER = Logger.getLogger(CogImageReader.class.getName());

    public CogImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        if (!(this.stream instanceof CogImageInputStream)) {
            return super.read(imageIndex, param);
        }
        if (!((CogImageInputStream)this.stream).isInitialized() && param instanceof CogImageReadParam) {
            ((CogImageInputStream)this.stream).init((CogImageReadParam)param);
        }
        if (!((CogImageInputStream)this.stream).isInitialized()) {
            throw new IOException("The CogImageInputStream has not been initialized.  Either pass a RangeReader implementation to the CogImageInputStream via the constructor or init method, or declare a valid RangeReader implementation class in the CogImageReadParam.");
        }
        Rectangle sourceRegion = param.getSourceRegion();
        if (sourceRegion != null) {
            LOGGER.fine("Reading pixels at offset (" + sourceRegion.getX() + ", " + sourceRegion.getY() + ") with a width of " + sourceRegion.getWidth() + "px and height of " + sourceRegion.getHeight() + "px");
        }
        this.prepareRead(imageIndex, param);
        this.theImage = CogImageReader.getDestination((ImageReadParam)param, (Iterator)this.getImageTypes(imageIndex), (int)this.width, (int)this.height, (Double)this.noData);
        Rectangle srcRegion = new Rectangle(0, 0, 0, 0);
        Rectangle destRegion = new Rectangle(0, 0, 0, 0);
        CogImageReader.computeRegions((ImageReadParam)this.imageReadParam, (int)this.width, (int)this.height, (BufferedImage)this.theImage, (Rectangle)srcRegion, (Rectangle)destRegion);
        this.tilesAcross = (this.width + this.tileOrStripWidth - 1) / this.tileOrStripWidth;
        this.tilesDown = (this.height + this.tileOrStripHeight - 1) / this.tileOrStripHeight;
        int minTileX = PlanarImage.XToTileX((int)srcRegion.x, (int)0, (int)this.tileOrStripWidth);
        int minTileY = PlanarImage.YToTileY((int)srcRegion.y, (int)0, (int)this.tileOrStripHeight);
        int maxTileX = PlanarImage.XToTileX((int)(srcRegion.x + srcRegion.width - 1), (int)0, (int)this.tileOrStripWidth);
        int maxTileY = PlanarImage.YToTileY((int)(srcRegion.y + srcRegion.height - 1), (int)0, (int)this.tileOrStripHeight);
        LOGGER.fine("Reading tiles (" + minTileX + "," + minTileY + ") - (" + maxTileX + "," + maxTileY + ")");
        CogTileInfo cogTileInfoHeader = ((CogImageInputStream)this.stream).getHeader();
        CogTileInfo cogTileInfo = new CogTileInfo(cogTileInfoHeader.getHeaderLength());
        if (this.planarConfiguration == 2) {
            for (int tileY = minTileY; tileY <= maxTileY; ++tileY) {
                for (int tileX = minTileX; tileX <= maxTileX; ++tileX) {
                    for (int band = 0; band < this.numBands; ++band) {
                        int tileIndex = band * this.tilesAcross * this.tilesDown;
                        long offset = this.getTileOrStripOffset(tileIndex);
                        long byteLength = this.getTileOrStripByteCount(tileIndex);
                        cogTileInfo.addTileRange(tileIndex, offset, byteLength);
                    }
                }
            }
        } else {
            for (int tileY = minTileY; tileY <= maxTileY; ++tileY) {
                for (int tileX = minTileX; tileX <= maxTileX; ++tileX) {
                    int tileIndex = tileY * this.tilesAcross + tileX;
                    long offset = this.getTileOrStripOffset(tileIndex);
                    long byteLength = this.getTileOrStripByteCount(tileIndex);
                    cogTileInfo.addTileRange(tileIndex, offset, byteLength);
                }
            }
        }
        cogTileInfoHeader.setHeaderLength(cogTileInfo.getHeaderLength());
        ((CogImageInputStream)this.stream).readRanges(cogTileInfo);
        return super.read(imageIndex, param);
    }
}

