/*
 * Decompiled with CFR 0.152.
 */
package ocss.nmea.parser;

import ocss.nmea.parser.GeoPos;
import ocss.nmea.parser.Wind;

public class StringParsers {
    public static final short DEPTH_IN_FEET = 0;
    public static final short DEPTH_IN_METERS = 1;
    public static final short DEPTH_IN_FATHOMS = 2;

    public static double parseVHW(String s) {
        double speed = 0.0;
        String str = "";
        try {
            if (s.indexOf(",N,") > -1 && s.indexOf(",M,") > -1 && s.indexOf(",N,") > s.indexOf(",M,")) {
                str = s.substring(s.indexOf(",M,") + ",M,".length(), s.indexOf(",N,"));
            }
            speed = Double.parseDouble(str);
        }
        catch (Exception e) {
            System.err.println(String.valueOf(String.valueOf("For ")) + s + ", " + e.toString());
        }
        return speed;
    }

    public static Wind parseMWV(String s) {
        Wind aw = null;
        try {
            if (s.indexOf("A*") == -1) {
                Wind wind = aw;
                return wind;
            }
            String speed = "";
            String angle = "";
            if (s.indexOf("MWV,") > -1 && s.indexOf(",R,") > -1) {
                angle = s.substring(s.indexOf("MWV,") + "MWV,".length(), s.indexOf(",R,"));
            }
            if (s.indexOf(",R,") > -1 && s.indexOf(",N,") > -1) {
                speed = s.substring(s.indexOf(",R,") + ",R,".length(), s.indexOf(",N,"));
            }
            aw = new Wind(Integer.parseInt(angle), Double.parseDouble(speed));
        }
        catch (Exception e) {
            System.err.println(String.valueOf(String.valueOf("For ")) + s + ", " + e.toString());
        }
        return aw;
    }

    public static GeoPos parseGLL(String s) {
        String str = "";
        GeoPos ll = null;
        try {
            if (s.indexOf("A*") == -1) {
                GeoPos geoPos = ll;
                return geoPos;
            }
            int i = s.indexOf(",");
            if (i > -1) {
                String lat = "";
                int j = s.indexOf(",", i + 1);
                lat = s.substring(i + 1, j);
                double l = Double.parseDouble(lat);
                int intL = (int)l / 100;
                double m = (l / 100.0 - (double)intL) * 100.0;
                l = (double)intL + (m *= 1.6666666666666667) / 100.0;
                String latSgn = s.substring(j + 1, j + 2);
                if (latSgn.equals("S")) {
                    l *= -1.0;
                }
                int k = s.indexOf(",", j + 3);
                String lng = s.substring(j + 3, k);
                double g = Double.parseDouble(lng);
                int intG = (int)g / 100;
                m = (g / 100.0 - (double)intG) * 100.0;
                g = (double)intG + (m *= 1.6666666666666667) / 100.0;
                String lngSgn = s.substring(k + 1, k + 2);
                if (lngSgn.equals("W")) {
                    g *= -1.0;
                }
                ll = new GeoPos(l, g);
            }
        }
        catch (Exception e) {
            System.err.println(String.valueOf(String.valueOf("For ")) + s + ", " + e.toString());
        }
        return ll;
    }

    public static int parseHDM(String s) {
        int hdg = 0;
        String str = "";
        try {
            if (s.indexOf("HDM,") > -1 && (str = s.substring(s.indexOf("HDM,") + "HDM,".length())).indexOf(",") > -1) {
                str = str.substring(0, str.indexOf(","));
                hdg = Integer.parseInt(str);
            }
        }
        catch (Exception e) {
            System.err.println(String.valueOf(String.valueOf("For ")) + s + ", " + e.toString());
        }
        return hdg;
    }

    public static String parseRMC(String data) {
        String s;
        String computed = "";
        String lat = "";
        String latSgn = "";
        String lon = "";
        String lonSgn = "";
        String nmeaKey = "";
        try {
            nmeaKey = data.substring(3, 6);
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        if (nmeaKey.equals("RMC") && data.indexOf(",A,") > -1) {
            String tmp = data.substring(data.indexOf(",A,") + ",A,".length());
            if (tmp.indexOf(",") > -1) {
                lat = tmp.substring(0, tmp.indexOf(","));
                tmp = tmp.substring(tmp.indexOf(",") + ",".length());
            }
            if (tmp.indexOf(",") > -1) {
                latSgn = tmp.substring(0, tmp.indexOf(","));
                tmp = tmp.substring(tmp.indexOf(",") + ",".length());
            }
            if (tmp.indexOf(",") > -1) {
                lon = tmp.substring(0, tmp.indexOf(","));
                tmp = tmp.substring(tmp.indexOf(",") + ",".length());
            }
            if (tmp.indexOf(",") > -1) {
                lonSgn = tmp.substring(0, tmp.indexOf(","));
                tmp = tmp.substring(tmp.indexOf(",") + ",".length());
            }
        }
        if (lat.length() > 0) {
            if (lat.indexOf(".") > -1) {
                s = lat.substring(0, lat.indexOf("."));
                lat = s = String.valueOf(s.substring(0, s.length() - 2)) + "\u00ba" + lat.substring(s.length() - 2);
            }
        } else {
            lat = "Not Set";
        }
        if (lon.length() > 0) {
            if (lon.indexOf(".") > -1) {
                s = lon.substring(0, lon.indexOf("."));
                lon = s = String.valueOf(s.substring(0, s.length() - 2)) + "\u00ba" + lon.substring(s.length() - 2);
            }
        } else {
            lon = "Not Set";
        }
        computed = String.valueOf(latSgn) + " " + lat + "/" + lonSgn + " " + lon;
        return computed;
    }

    public static float parseDBT(String s, short unit) {
        float feet = 0.0f;
        float meters = 0.0f;
        float fathoms = 0.0f;
        String str = "";
        String first = "";
        String last = "";
        try {
            first = "DBT,";
            last = ",f,";
            if (s.indexOf(first) > -1 && s.indexOf(last) > -1 && s.indexOf(first) < s.indexOf(last)) {
                str = s.substring(s.indexOf(first) + first.length(), s.indexOf(last));
            }
            feet = Float.parseFloat(str);
            first = ",f,";
            last = ",M,";
            if (s.indexOf(first) > -1 && s.indexOf(last) > -1 && s.indexOf(first) < s.indexOf(last)) {
                str = s.substring(s.indexOf(first) + first.length(), s.indexOf(last));
            }
            meters = Float.parseFloat(str);
            first = ",M,";
            last = ",F";
            if (s.indexOf(first) > -1 && s.indexOf(last) > -1 && s.indexOf(first) < s.indexOf(last)) {
                str = s.substring(s.indexOf(first) + first.length(), s.indexOf(last));
            }
            fathoms = Float.parseFloat(str);
        }
        catch (Exception e) {
            System.err.println(String.valueOf(String.valueOf("For ")) + s + ", " + e.toString());
        }
        if (unit == 0) {
            return feet;
        }
        if (unit == 1) {
            return meters;
        }
        if (unit == 2) {
            return fathoms;
        }
        return feet;
    }
}

