/*
 * Decompiled with CFR 0.152.
 */
package ocss.nmea.api;

import java.util.ArrayList;
import ocss.nmea.api.NMEAEvent;
import ocss.nmea.api.NMEAListener;

public abstract class NMEAReader
extends Thread {
    private transient ArrayList NMEAListeners = null;
    boolean goRead = true;

    public NMEAReader(ArrayList al) {
        System.out.println("Creating reader");
        this.NMEAListeners = al;
        this.addNMEAListener(new NMEAListener(){

            public void stopReading(NMEAEvent e) {
                System.out.println("Stopping reading");
                NMEAReader.this.goRead = false;
            }
        });
    }

    protected void fireDataRead(NMEAEvent e) {
        for (int i = 0; i < this.NMEAListeners.size(); ++i) {
            NMEAListener l = (NMEAListener)this.NMEAListeners.get(i);
            l.dataRead(e);
        }
    }

    public synchronized void addNMEAListener(NMEAListener l) {
        if (!this.NMEAListeners.contains(l)) {
            this.NMEAListeners.add(l);
        }
    }

    public synchronized void removeNMEAListener(NMEAListener l) {
        this.NMEAListeners.remove(l);
    }

    public boolean canRead() {
        return this.goRead;
    }

    public void enableReading() {
        this.goRead = true;
    }

    public abstract void read();

    public void run() {
        System.out.println("Reader Running");
        this.read();
    }
}

