/*
 * Decompiled with CFR 0.152.
 */
package ocss.nmea.api;

import java.util.ArrayList;
import ocss.nmea.api.NMEAEvent;
import ocss.nmea.api.NMEAException;
import ocss.nmea.api.NMEAListener;

public final class NMEAParser
extends Thread {
    protected String nmeaPrefix = "";
    private String[] nmeaSentence = null;
    private String nmeaStream = "";
    private static final long MAX_STREAM_SIZE = 2048L;
    private static final String NMEA_EOS = "\r\n";
    private transient ArrayList NMEAListeners = null;

    public NMEAParser(ArrayList al) {
        System.out.println("Creating parser");
        this.NMEAListeners = al;
        this.addNMEAListener(new NMEAListener(){

            public void dataRead(NMEAEvent e) {
                NMEAParser.this.nmeaStream = String.valueOf(NMEAParser.this.nmeaStream) + e.getContent();
            }
        });
    }

    public String getNmeaPrefix() {
        return this.nmeaPrefix;
    }

    public void setNmeaPrefix(String s) {
        this.nmeaPrefix = s;
    }

    public String[] getNmeaSentence() {
        return this.nmeaSentence;
    }

    public void setNmeaSentence(String[] sa) {
        this.nmeaSentence = sa;
    }

    public String getNmeaStream() {
        return this.nmeaStream;
    }

    public void setNmeaStream(String s) {
        this.nmeaStream = s;
    }

    public String detectSentence() throws NMEAException {
        String ret = null;
        if (!this.interesting()) {
            if ((long)this.nmeaStream.length() > 2048L) {
                this.nmeaStream = "";
            }
            String end = null;
            return end;
        }
        int end = this.nmeaStream.indexOf(NMEA_EOS);
        ret = this.nmeaStream.substring(0, end);
        this.nmeaStream = this.nmeaStream.substring(end + NMEA_EOS.length());
        return ret;
    }

    private boolean interesting() throws NMEAException {
        if (this.nmeaPrefix.length() == 0) {
            throw new NMEAException("NMEA Prefix is not set");
        }
        int beginIdx = this.nmeaStream.indexOf(String.valueOf(String.valueOf("$")) + this.nmeaPrefix);
        int endIdx = this.nmeaStream.indexOf(NMEA_EOS);
        if (beginIdx == -1 && endIdx == -1) {
            return false;
        }
        if (endIdx > -1 && endIdx < beginIdx) {
            this.nmeaStream = this.nmeaStream.substring(endIdx + NMEA_EOS.length());
            beginIdx = this.nmeaStream.indexOf(String.valueOf(String.valueOf("$")) + this.nmeaPrefix);
        }
        if (beginIdx == -1) {
            return false;
        }
        while (true) {
            try {
                int i;
                if (this.nmeaStream.length() > 6) {
                    endIdx = this.nmeaStream.indexOf(NMEA_EOS);
                    if (endIdx > -1) {
                        for (i = 0; i < this.nmeaSentence.length; ++i) {
                            if (!this.nmeaStream.startsWith(String.valueOf(String.valueOf("$")) + this.nmeaPrefix + this.nmeaSentence[i])) continue;
                            boolean bl = true;
                            return bl;
                        }
                        this.nmeaStream = this.nmeaStream.substring(endIdx + NMEA_EOS.length());
                        continue;
                    }
                    i = 0;
                    return i != 0;
                }
                i = 0;
                return i != 0;
            }
            catch (Exception e) {
                System.err.println("Oooch!");
                e.printStackTrace();
                System.out.println(String.valueOf(String.valueOf("nmeaStream.length = ")) + this.nmeaStream.length() + ", Stream:[" + this.nmeaStream + "]");
                continue;
            }
            break;
        }
    }

    protected void fireDataDetected(NMEAEvent e) {
        for (int i = 0; i < this.NMEAListeners.size(); ++i) {
            NMEAListener l = (NMEAListener)this.NMEAListeners.get(i);
            l.dataDetected(e);
        }
    }

    public synchronized void addNMEAListener(NMEAListener l) {
        if (!this.NMEAListeners.contains(l)) {
            this.NMEAListeners.add(l);
        }
    }

    public synchronized void removeNMEAListener(NMEAListener l) {
        this.NMEAListeners.remove(l);
    }

    public void loop() {
        while (true) {
            try {
                String s = "";
                while ((s = this.detectSentence()) != null) {
                    this.fireDataDetected(new NMEAEvent(this, s));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void run() {
        System.out.println("Parser Running");
        this.loop();
    }
}

