/*
 * Decompiled with CFR 0.152.
 */
package ocss.nmea.api;

import java.util.ArrayList;
import ocss.nmea.api.NMEAEvent;
import ocss.nmea.api.NMEAListener;
import ocss.nmea.api.NMEAParser;
import ocss.nmea.api.NMEAReader;

public abstract class NMEAClient {
    private transient ArrayList NMEAListeners = new ArrayList(2);
    private NMEAParser parser;
    private NMEAReader reader;
    private String devicePrefix = "";
    private String[] sentenceArray = null;

    public NMEAClient() {
    }

    public NMEAClient(String prefix, String[] sentence) {
        this.setDevicePrefix(prefix);
        this.setSentenceArray(sentence);
    }

    public void initClient() {
        this.addNMEAListener(new NMEAListener(){

            public void dataDetected(NMEAEvent e) {
                NMEAClient.this.dataDetectedEvent(e);
            }
        });
        this.parser = new NMEAParser(this.NMEAListeners);
        this.parser.setNmeaPrefix(this.getDevicePrefix());
        this.parser.setNmeaSentence(this.getSentenceArray());
    }

    public void setDevicePrefix(String s) {
        this.devicePrefix = s;
    }

    public String getDevicePrefix() {
        return this.devicePrefix;
    }

    public void setSentenceArray(String[] sa) {
        this.sentenceArray = sa;
    }

    public String[] getSentenceArray() {
        return this.sentenceArray;
    }

    public void setParser(NMEAParser p) {
        this.parser = p;
    }

    public NMEAParser getParser() {
        return this.parser;
    }

    public void setReader(NMEAReader r) {
        this.reader = r;
    }

    public NMEAReader getReader() {
        return this.reader;
    }

    public ArrayList getListeners() {
        return this.NMEAListeners;
    }

    public void startWorking() {
        this.reader.start();
        this.parser.start();
    }

    public abstract void dataDetectedEvent(NMEAEvent var1);

    public synchronized void addNMEAListener(NMEAListener l) {
        if (!this.NMEAListeners.contains(l)) {
            this.NMEAListeners.add(l);
        }
    }

    public synchronized void removeNMEAListener(NMEAListener l) {
        this.NMEAListeners.remove(l);
    }
}

