/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class MultiPointHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory;

    public MultiPointHandler(GeometryFactory gf) {
        this.shapeType = ShapeType.POINT;
        this.geometryFactory = gf;
    }

    public MultiPointHandler(ShapeType type, GeometryFactory gf) throws ShapefileException {
        if (!type.isMultiPointType()) {
            throw new ShapefileException("Multipointhandler constructor - expected type to be 8, 18, or 28");
        }
        this.shapeType = type;
        this.geometryFactory = gf;
    }

    @Override
    public ShapeType getShapeType() {
        return this.shapeType;
    }

    @Override
    public int getLength(Object geometry) {
        int length;
        MultiPoint mp = (MultiPoint)geometry;
        if (this.shapeType == ShapeType.MULTIPOINT) {
            length = mp.getNumGeometries() * 16 + 40;
        } else if (this.shapeType == ShapeType.MULTIPOINTM) {
            length = mp.getNumGeometries() * 16 + 40 + 16 + 8 * mp.getNumGeometries();
        } else if (this.shapeType == ShapeType.MULTIPOINTZ) {
            length = mp.getNumGeometries() * 16 + 40 + 16 + 8 * mp.getNumGeometries() + 16 + 8 * mp.getNumGeometries();
        } else {
            throw new IllegalStateException("Expected ShapeType of Arc, got " + (Object)((Object)this.shapeType));
        }
        return length;
    }

    private Object createNull() {
        return this.geometryFactory.createMultiPoint((CoordinateSequence)null);
    }

    @Override
    public Object read(ByteBuffer buffer, ShapeType type, boolean flatGeometry) {
        boolean isArcZWithM;
        int t;
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        ((Buffer)buffer).position(buffer.position() + 32);
        int numpoints = buffer.getInt();
        int dimensions = this.shapeType == ShapeType.MULTIPOINTZ && !flatGeometry ? 3 : 2;
        int measure = flatGeometry ? 0 : 1;
        CoordinateSequence cs = this.shapeType == ShapeType.MULTIPOINTZ || this.shapeType == ShapeType.MULTIPOINTM ? JTS.createCS(this.geometryFactory.getCoordinateSequenceFactory(), numpoints, dimensions + measure, measure) : JTS.createCS(this.geometryFactory.getCoordinateSequenceFactory(), numpoints, dimensions);
        DoubleBuffer dbuffer = buffer.asDoubleBuffer();
        double[] ordinates = new double[numpoints * 2];
        dbuffer.get(ordinates);
        for (t = 0; t < numpoints; ++t) {
            cs.setOrdinate(t, 0, ordinates[t * 2]);
            cs.setOrdinate(t, 1, ordinates[t * 2 + 1]);
        }
        if (this.shapeType == ShapeType.MULTIPOINTZ && !flatGeometry) {
            ((Buffer)dbuffer).position(dbuffer.position() + 2);
            dbuffer.get(ordinates, 0, numpoints);
            for (t = 0; t < numpoints; ++t) {
                cs.setOrdinate(t, 2, ordinates[t]);
            }
        }
        boolean bl = isArcZWithM = this.shapeType == ShapeType.MULTIPOINTZ && dbuffer.hasRemaining();
        if ((isArcZWithM || this.shapeType == ShapeType.MULTIPOINTM) && !flatGeometry) {
            ((Buffer)dbuffer).position(dbuffer.position() + 2);
            dbuffer.get(ordinates, 0, numpoints);
            for (int t2 = 0; t2 < numpoints; ++t2) {
                cs.setOrdinate(t2, 3, ordinates[t2]);
            }
        }
        return this.geometryFactory.createMultiPoint(cs);
    }

    @Override
    public void write(ByteBuffer buffer, Object geometry) {
        MultiPoint mp = (MultiPoint)geometry;
        Envelope box = mp.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        buffer.putInt(mp.getNumGeometries());
        int tt = mp.getNumGeometries();
        for (int t = 0; t < tt; ++t) {
            Coordinate c = mp.getGeometryN(t).getCoordinate();
            buffer.putDouble(c.x);
            buffer.putDouble(c.y);
        }
        if (this.shapeType == ShapeType.MULTIPOINTZ) {
            double[] result = new double[]{Double.NaN, Double.NaN};
            JTSUtilities.zMinMax((CoordinateSequence)new CoordinateArraySequence(mp.getCoordinates()), result);
            double[] zExtreame = result;
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            for (int t = 0; t < mp.getNumGeometries(); ++t) {
                Coordinate c = mp.getGeometryN(t).getCoordinate();
                double z = c.getZ();
                if (Double.isNaN(z)) {
                    buffer.putDouble(0.0);
                    continue;
                }
                buffer.putDouble(z);
            }
        }
        if (this.shapeType == ShapeType.MULTIPOINTM || this.shapeType == ShapeType.MULTIPOINTZ) {
            ArrayList<Double> mvalues = new ArrayList<Double>();
            int tt2 = mp.getNumGeometries();
            for (int t = 0; t < tt2; ++t) {
                Point point = (Point)mp.getGeometryN(t);
                mvalues.add(point.getCoordinateSequence().getM(0));
            }
            buffer.putDouble((Double)mvalues.stream().min(Double::compare).get());
            buffer.putDouble((Double)mvalues.stream().max(Double::compare).get());
            mvalues.forEach(x -> buffer.putDouble((double)x));
        }
    }
}

