/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.zip;

import de.riwagis.util.zip.FileModifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ZipUtils {
    public static final String ZIP_DIRECTORY_SEPARATOR = "/";

    public static void compressDirToZipArchive(File zipFile, File fileToZip, String parentDirectoryName, boolean includeDirectory) throws IOException {
        ZipUtils.compressDirToZipArchive(zipFile, fileToZip, parentDirectoryName, includeDirectory, null);
    }

    public static void compressDirToZipArchive(File zipFile, File fileToZip, String parentDirectoryName, boolean includeDirectory, FileModifier modifier) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
             ZipOutputStream zout = new ZipOutputStream(fileOutputStream);){
            ZipUtils.compressDirToZipArchive(zout, fileToZip, parentDirectoryName, includeDirectory, modifier);
        }
    }

    public static void compressDirToZipArchive(ZipOutputStream zos, File fileToZip, String parentDirectoryName, boolean includeDirectory) throws IOException {
        ZipUtils.compressDirToZipArchive(zos, fileToZip, parentDirectoryName, includeDirectory, null);
    }

    public static void compressDirToZipArchive(ZipOutputStream zos, File fileToZip, String parentDirectoryName, boolean includeDirectory, FileModifier modifier) throws IOException {
        if (fileToZip == null || !fileToZip.exists()) {
            return;
        }
        Object zipEntryName = "";
        if (StringUtils.isNotBlank((CharSequence)parentDirectoryName)) {
            zipEntryName = parentDirectoryName;
        }
        if (includeDirectory) {
            if (!((String)zipEntryName).isEmpty()) {
                zipEntryName = (String)zipEntryName + ZIP_DIRECTORY_SEPARATOR;
            }
            zipEntryName = (String)zipEntryName + fileToZip.getName();
        }
        if (fileToZip.isDirectory()) {
            if (includeDirectory) {
                zos.putNextEntry(new ZipEntry((String)zipEntryName + ZIP_DIRECTORY_SEPARATOR));
            }
            for (File file : fileToZip.listFiles()) {
                ZipUtils.compressDirToZipArchive(zos, file, (String)zipEntryName, true, modifier);
            }
        } else {
            ZipUtils.compressFile2ZipEntry(fileToZip, zos, (String)zipEntryName, modifier);
        }
    }

    public static void compressFile2ZipEntry(File file2Compress, ZipOutputStream zos, String zipEntryName) throws IOException {
        ZipUtils.compressFile2ZipEntry(file2Compress, zos, zipEntryName, null);
    }

    public static void compressFile2ZipEntry(File file2Compress, ZipOutputStream zos, String zipEntryName, FileModifier modifier) throws IOException {
        if (modifier != null && modifier.matches(file2Compress)) {
            try (InputStream fis = modifier.modify(file2Compress);){
                zos.putNextEntry(new ZipEntry(zipEntryName));
                IOUtils.copy((InputStream)fis, (OutputStream)zos);
                zos.closeEntry();
            }
        }
        try (FileInputStream fis = new FileInputStream(file2Compress);){
            zos.putNextEntry(new ZipEntry(zipEntryName));
            IOUtils.copy((InputStream)fis, (OutputStream)zos);
            zos.closeEntry();
        }
    }

    public static void extractZip2Directory(ZipInputStream zipIn, File destDir, String entryRegExp) throws IOException {
        ZipEntry entry;
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        if (!destDir.isDirectory()) {
            throw new IllegalArgumentException(String.format("Directory required for '%s'", destDir.getAbsolutePath()));
        }
        Pattern p = Pattern.compile((String)StringUtils.defaultIfBlank((CharSequence)entryRegExp, (CharSequence)".*"));
        while ((entry = zipIn.getNextEntry()) != null) {
            String entryName = entry.getName();
            if (!p.matcher(entryName).matches()) continue;
            File filePath = new File(destDir, entryName);
            if (entry.isDirectory()) {
                filePath.mkdir();
            } else {
                ZipUtils.extractZipEntry2File(zipIn, filePath);
            }
            zipIn.closeEntry();
        }
    }

    public static void extractZipEntry2File(ZipInputStream zipIn, File destinationFile) throws IOException {
        Objects.requireNonNull(zipIn, "ZIP input must not be null");
        Objects.requireNonNull(destinationFile, "destination file must not be null");
        destinationFile.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(destinationFile);){
            IOUtils.copy((InputStream)zipIn, (OutputStream)fos);
        }
    }

    public static File extractZipEntry2File(File zipFile, String filename) throws IOException {
        Objects.requireNonNull(zipFile, "ZIP file must not be null");
        Objects.requireNonNull(filename, "ZIP filename must not be null");
        File destinationFile = File.createTempFile(FilenameUtils.getName((String)filename), ".tmp");
        if (ZipUtils.extractZipEntry2File(zipFile, filename, destinationFile)) {
            return destinationFile;
        }
        FileUtils.deleteQuietly((File)destinationFile);
        return null;
    }

    public static boolean extractZipEntry2File(File zipFile, String filename, File destinationFile) throws IOException {
        Objects.requireNonNull(zipFile, "ZIP file must not be null");
        Objects.requireNonNull(filename, "ZIP filename must not be null");
        Objects.requireNonNull(destinationFile, "destination file must not be null");
        try (ZipInputStream f = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry ze;
            while ((ze = f.getNextEntry()) != null) {
                if (!StringUtils.equals((CharSequence)ze.getName(), (CharSequence)filename)) continue;
                ZipUtils.extractZipEntry2File(f, destinationFile);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

