/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.file.fileinfo;

import de.riwagis.util.csv.CSVSupport;
import de.riwagis.util.file.fileinfo.FileInfoListEntry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileInfoUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileInfoUtils.class);
    private static final ThreadLocal<SimpleDateFormat> ISODATETIMEFORMAT_OUT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> ISODATETIMEFORMAT_IN = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
    };
    private static final List<String> header = Arrays.asList("file", "md5", "size", "time");
    public static final char CSV_DELIM = ';';
    public static final char CSV_QUOTE = '\"';
    public static final char CSV_DECI = '.';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMD5sum(File md5sumFile, Collection<FileInfoListEntry> fileHashes) throws IOException {
        FileUtils.deleteQuietly((File)md5sumFile);
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(md5sumFile), "UTF-8"));
        try {
            for (FileInfoListEntry currFileHashContainer : fileHashes) {
                wr.write(String.format("%s  %s", currFileHashContainer.getMd5sum(), currFileHashContainer.getRelativeFilename()));
                wr.newLine();
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)wr);
        }
    }

    public static final Map<String, FileInfoListEntry> makeIndex(Collection<FileInfoListEntry> fileHashes, boolean doLowercase) {
        LinkedHashMap<String, FileInfoListEntry> index = new LinkedHashMap<String, FileInfoListEntry>(fileHashes.size());
        for (FileInfoListEntry currEntry : fileHashes) {
            if (doLowercase) {
                index.put(StringUtils.lowerCase((String)currEntry.getRelativeFilename()), currEntry);
                continue;
            }
            index.put(currEntry.getRelativeFilename(), currEntry);
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void readFromFile(File input, Collection<FileInfoListEntry> coll) throws IOException {
        block6: {
            InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(input), StandardCharsets.UTF_8);
            try {
                ArrayList<String> currline = new ArrayList<String>();
                if (CSVSupport.readCsvLine(';', '\"', r, currline)) break block6;
                currline.clear();
                while (!CSVSupport.readCsvLine(';', '\"', r, currline)) {
                    FileInfoListEntry filste = new FileInfoListEntry();
                    filste.setRelativeFilename((String)currline.get(0));
                    filste.setMd5sum((String)currline.get(1));
                    filste.setFileSize(Long.valueOf((String)currline.get(2)));
                    try {
                        filste.setFileDate(ISODATETIMEFORMAT_OUT.get().parse((String)currline.get(3)));
                    }
                    catch (ParseException pex) {
                        filste.setFileTimestamp(0L);
                        LOG.debug(String.format("unable to parse date '%s': %s", currline.get(3), pex.getMessage()));
                    }
                    coll.add(filste);
                    currline.clear();
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeToFile(File output, Collection<FileInfoListEntry> coll) throws IOException {
        FileUtils.deleteQuietly((File)output);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);
        try {
            w.write(CSVSupport.buildCSVTitleLine(header, ';', '\"', '.'));
            w.write("\n");
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            for (FileInfoListEntry currFileInfo : coll) {
                data.put("file", currFileInfo.getRelativeFilename());
                data.put("md5", currFileInfo.getMd5sum());
                data.put("size", Long.toString(currFileInfo.getFileSize()));
                data.put("time", ISODATETIMEFORMAT_IN.get().format(currFileInfo.getFileTimestamp()));
                w.write(CSVSupport.buildCSVDataLine(header, data, ';', '\"', '.'));
                w.write("\n");
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)w);
        }
    }

    private FileInfoUtils() {
    }
}

