/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.file.fileinfo;

import de.riwagis.util.file.FileHashContainer;
import de.riwagis.util.file.PathSupport;
import de.riwagis.util.file.fileinfo.FileInfoListEntry;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInfoDirectoryWalker
extends DirectoryWalker<FileInfoListEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(FileInfoDirectoryWalker.class);
    private final File baseDir;
    private final String baseDirStr;
    private final Map<String, FileInfoListEntry> knownFiles = new LinkedHashMap<String, FileInfoListEntry>();
    private final Collection<String> ignoredFiles = new LinkedHashSet<String>();

    public FileInfoDirectoryWalker(File baseDir, Collection<FileInfoListEntry> knownFiles) {
        this.baseDir = baseDir;
        this.baseDirStr = baseDir.getAbsolutePath();
        for (FileInfoListEntry currFile : knownFiles) {
            this.knownFiles.put(currFile.getRelativeFilename(), currFile);
        }
    }

    protected void handleFile(File file, int depth, Collection<FileInfoListEntry> results) throws IOException {
        super.handleFile(file, depth, results);
        String currRelPath = FilenameUtils.separatorsToUnix((String)PathSupport.calcRelativePath(file.getAbsolutePath(), this.baseDirStr));
        if (!this.ignoredFiles.contains(currRelPath)) {
            FileInfoListEntry fif = this.knownFiles.get(currRelPath);
            if (fif == null || file.lastModified() != fif.getFileTimestamp().longValue() || file.length() != fif.getFileSize().longValue()) {
                if (fif == null) {
                    fif = new FileInfoListEntry();
                    fif.setRelativeFilename(currRelPath);
                }
                fif.setMd5sum(FileHashContainer.calcFileMD5HashCode(file));
                LOG.debug(String.format("file hash calculated for '%s': %s", currRelPath, fif.getMd5sum()));
            } else {
                LOG.debug(String.format("file hash not calculated for '%s': %s", currRelPath, fif.getMd5sum()));
            }
            fif.updateDate(file);
            results.add(fif);
        }
    }

    public static final Map<String, FileInfoListEntry> startDir(File baseDir, Collection<FileInfoListEntry> knownFiles, Collection<String> ignoredFiles) throws IOException {
        FileInfoDirectoryWalker f = new FileInfoDirectoryWalker(baseDir, knownFiles);
        if (ignoredFiles != null) {
            for (String currIgnoredFile : ignoredFiles) {
                if (!StringUtils.isNotBlank((CharSequence)currIgnoredFile)) continue;
                f.addIgnoreFile(currIgnoredFile);
            }
        }
        LinkedHashMap<String, FileInfoListEntry> indexedEntries = new LinkedHashMap<String, FileInfoListEntry>();
        for (FileInfoListEntry currEntry : f.start()) {
            indexedEntries.put(currEntry.getRelativeFilename(), currEntry);
        }
        return indexedEntries;
    }

    public Collection<FileInfoListEntry> start() throws IOException {
        LinkedHashSet<FileInfoListEntry> foundFiles = new LinkedHashSet<FileInfoListEntry>();
        this.walk(this.baseDir, foundFiles);
        return foundFiles;
    }

    public void addIgnoreFile(String ignoredFile) {
        this.ignoredFiles.add(ignoredFile);
    }
}

