/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TempFileSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TempFileSupport.class);

    public static File createTempDir(String prefix, String suffix) throws IOException {
        File tmpDirRoot = File.createTempFile(prefix, suffix);
        if (tmpDirRoot.delete() && tmpDirRoot.mkdirs()) {
            return tmpDirRoot;
        }
        throw new IOException(String.format("unable to create temp dir '%s'", tmpDirRoot));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFileTemp(File sourceFile, File targetFile) throws IOException {
        File targetDir = targetFile.getParentFile();
        if (targetDir.mkdirs()) {
            LOG.info("dir created: '%s'", (Object)targetDir);
        }
        File targetFileTemp = File.createTempFile("copy_", ".tmp", targetDir);
        LOG.debug(String.format("copy file '%s' to temporary file '%s'", sourceFile, targetFile));
        Files.copy(sourceFile.toPath(), targetFileTemp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        LOG.debug(String.format("move file '%s' to final file '%s'", targetFileTemp, targetFile));
        try {
            Files.move(targetFileTemp.toPath(), targetFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            LOG.info(String.format("file '%s' copied to '%s'", sourceFile, targetFile));
            if (!targetFileTemp.delete()) return;
        }
        catch (IOException ioex) {
            try {
                throw new IOException(String.format("failed to copy '%s' to '%s': %s", sourceFile, targetFile, ioex.getMessage()), ioex);
            }
            catch (Throwable throwable) {
                if (!targetFileTemp.delete()) throw throwable;
                LOG.warn(String.format("delete temporary file '%s'", targetFileTemp));
                throw throwable;
            }
        }
        LOG.warn(String.format("delete temporary file '%s'", targetFileTemp));
        return;
    }

    private TempFileSupport() {
    }
}

