/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(TempFileOutputStream.class);
    private final OutputStream tempFileOutputStream;
    private final File targetFile;
    private final File tempFile;
    private boolean closed = false;
    private static final Collection<File> openFiles = new LinkedHashSet<File>();

    public TempFileOutputStream(File targetFile) throws IOException {
        this(targetFile.getAbsoluteFile().getParentFile(), targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempFileOutputStream(File tempDir, File targetFile) throws IOException {
        Collection<File> collection = openFiles;
        synchronized (collection) {
            if (openFiles.contains(targetFile)) {
                throw new IOException(String.format("file '%s' already written", targetFile));
            }
            Path tempFilePath = Files.createTempFile(targetFile.getParentFile().toPath(), targetFile.getName() + "_", ".tmp", new FileAttribute[0]);
            this.tempFile = tempFilePath.toFile();
            this.tempFileOutputStream = new FileOutputStream(this.tempFile);
            this.targetFile = targetFile;
            openFiles.add(targetFile);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.tempFileOutputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.tempFileOutputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.tempFileOutputStream.write(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            Collection<File> collection = openFiles;
            synchronized (collection) {
                openFiles.remove(this.targetFile);
                this.closed = true;
                try (OutputStream outputStream = this.tempFileOutputStream;){
                    super.close();
                }
                if (!this.targetFile.delete() || !this.targetFile.exists()) {
                    Files.move(this.tempFile.toPath(), this.targetFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        LOG.debug(String.format("file '%s': already closed", this.targetFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
        Collection<File> collection = openFiles;
        synchronized (collection) {
            if (openFiles.contains(this.targetFile)) {
                try {
                    this.tempFileOutputStream.close();
                }
                catch (IOException ioex) {
                    LOG.warn(String.format("unable to close '%s': %s", this.targetFile, ioex.getMessage()), (Throwable)ioex);
                }
                FileUtils.deleteQuietly((File)this.tempFile);
                openFiles.remove(this.targetFile);
                LOG.warn(String.format("file '%s' was not closed by close method.", this.targetFile));
            }
        }
    }
}

