/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceSupport.class);

    public static File copyResourceFileToDirectory(Class<?> clazz, String resname, File destinationDir) throws IOException {
        return ResourceSupport.copyResourceFileToFile(clazz, resname, new File(destinationDir, FilenameUtils.getName((String)resname)));
    }

    public static File copyResourceFileToDirectory(String resname, File destinationDir) throws IOException {
        return ResourceSupport.copyResourceFileToDirectory(ResourceSupport.class, resname, destinationDir);
    }

    public static final File copyResourceFileToFile(String resname, File destinationFile) throws IOException {
        return ResourceSupport.copyResourceFileToFile(ResourceSupport.class, resname, destinationFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File copyResourceFileToFile(Class<?> clazz, String resname, File destinationFile) throws IOException {
        InputStream is = clazz.getResourceAsStream(resname);
        try {
            LOG.debug(String.format("Copy file: '<STREAM@%s>' --> '%s'", ResourceSupport.resourceAsURL(clazz, resname), destinationFile));
            FileUtils.deleteQuietly((File)destinationFile);
            FileOutputStream os = new FileOutputStream(destinationFile);
            try {
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return destinationFile;
    }

    public static URL resourceAsURL(String resname) throws IOException {
        return ResourceSupport.resourceAsURL(ResourceSupport.class, resname);
    }

    public static URL resourceAsURL(Class<?> clazz, String resname) throws IOException {
        URL resUrl = clazz.getResource(resname);
        if (resUrl == null) {
            throw new IOException(String.format("Resource '%s' not found", resname));
        }
        return resUrl;
    }

    public static File copyResourceFileToTempFile(Class<?> clazz, String resname) throws IOException {
        String ext = FilenameUtils.getExtension((String)resname);
        String name = FilenameUtils.getBaseName((String)resname);
        File dstFile = File.createTempFile(name, (String)(StringUtils.isBlank((CharSequence)ext) ? "" : "." + ext));
        return ResourceSupport.copyResourceFileToFile(clazz, resname, dstFile);
    }

    public static final File copyResourceFileToTempFile(String resname) throws IOException {
        return ResourceSupport.copyResourceFileToTempFile(ResourceSupport.class, resname);
    }

    private ResourceSupport() {
    }
}

