/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.file;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class PathSupport {
    public static String calcRelativePath(String targetPath, String basePath) {
        return PathSupport.calcRelativePath(targetPath, basePath, File.separator);
    }

    public static String calcRelativePath(String targetPath, String basePath, String pathSeparator) {
        int commonIndex;
        String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator((String)targetPath);
        String normalizedBasePath = FilenameUtils.normalizeNoEndSeparator((String)basePath);
        switch (pathSeparator) {
            case "/": {
                normalizedTargetPath = FilenameUtils.separatorsToUnix((String)normalizedTargetPath);
                normalizedBasePath = FilenameUtils.separatorsToUnix((String)normalizedBasePath);
                break;
            }
            case "\\": {
                normalizedTargetPath = FilenameUtils.separatorsToWindows((String)normalizedTargetPath);
                normalizedBasePath = FilenameUtils.separatorsToWindows((String)normalizedBasePath);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
            }
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuilder common = new StringBuilder();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex]).append(pathSeparator);
        }
        if (commonIndex == 0) {
            throw new IllegalArgumentException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuilder relative = new StringBuilder();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append("..").append(pathSeparator);
            }
        }
        if (common.length() >= 0 && common.length() <= normalizedTargetPath.length()) {
            relative.append(normalizedTargetPath.substring(common.length()));
        }
        return relative.toString();
    }

    private PathSupport() {
    }
}

