/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeTypeSupport {
    private static final Logger logger = LoggerFactory.getLogger(MimeTypeSupport.class);
    private static final Set<String> registredExtensions = new HashSet<String>();
    private static final List<String> knownOctetStreamExtensions = new ArrayList<String>();
    private static Tika tika = null;

    private MimeTypeSupport() {
    }

    public static String detectMimeType(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream, "InputStream cannot be null");
        return MimeTypeSupport.detectMimeTypeFromSource(inputStream);
    }

    public static String detectMimeType(File file) throws IOException {
        Objects.requireNonNull(file, "File cannot be null");
        return MimeTypeSupport.detectMimeTypeFromSource(file);
    }

    public static String detectMimeType(Path path) throws IOException {
        Objects.requireNonNull(path, "Path cannot be null");
        return MimeTypeSupport.detectMimeType(path.toFile());
    }

    public static String detectMimeType(byte[] data) throws IOException {
        Objects.requireNonNull(data, "Byte array cannot be null");
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
            String string = MimeTypeSupport.detectMimeType(inputStream);
            return string;
        }
    }

    public static CheckResult checkMimeType(InputStream inputStream, String fileName) throws IOException {
        Objects.requireNonNull(inputStream, "InputStream cannot be null");
        return MimeTypeSupport.checkMimeTypeInternal(inputStream, fileName);
    }

    public static CheckResult checkMimeType(File file, String fileName) throws IOException {
        Objects.requireNonNull(file, "File cannot be null");
        return MimeTypeSupport.checkMimeTypeInternal(file, fileName);
    }

    public static CheckResult checkMimeType(Path path, String fileName) throws IOException {
        Objects.requireNonNull(path, "Path cannot be null");
        return MimeTypeSupport.checkMimeType(path.toFile(), fileName);
    }

    public static CheckResult checkMimeType(byte[] data, String fileName) throws IOException {
        Objects.requireNonNull(data, "Byte array cannot be null");
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
            CheckResult checkResult = MimeTypeSupport.checkMimeType(inputStream, fileName);
            return checkResult;
        }
    }

    private static String detectMimeTypeFromSource(Object source) throws IOException {
        if (tika == null) {
            logger.error("Apache Tika is not available for MIME type detection.");
            return null;
        }
        if (source instanceof InputStream) {
            InputStream is = (InputStream)source;
            return tika.detect(is);
        }
        if (source instanceof File) {
            File f = (File)source;
            try (FileInputStream is = new FileInputStream(f);){
                String string = tika.detect((InputStream)is);
                return string;
            }
        }
        throw new IllegalArgumentException("Unsupported source type: " + source.getClass().getName());
    }

    private static CheckResult checkMimeTypeInternal(Object source, String fileName) throws IOException {
        if (tika == null) {
            logger.error("Apache Tika is not available for MIME type detection.");
            return CheckResult.WARN;
        }
        if (StringUtils.isBlank((CharSequence)fileName) || StringUtils.isBlank((CharSequence)FilenameUtils.getExtension((String)fileName))) {
            logger.warn("MIME type check skipped: Missing or empty filename or extension for source: '{}'", (Object)source.getClass().getSimpleName());
            return CheckResult.WARN;
        }
        String extension = FilenameUtils.getExtension((String)fileName).toLowerCase();
        if (!registredExtensions.contains(extension)) {
            logger.warn("Unknown or unregistered file extension: '{}' for filename: {}", (Object)extension, (Object)fileName);
            return CheckResult.WARN;
        }
        MediaType detectedMediaType = MediaType.parse((String)MimeTypeSupport.detectMimeTypeFromSource(source));
        if (MediaType.OCTET_STREAM.equals((Object)detectedMediaType) && !knownOctetStreamExtensions.contains(extension)) {
            logger.error("MIME type error: Could not determine content type (got generic 'application/octet-stream') for file: '{}'", (Object)fileName);
            return CheckResult.ERROR;
        }
        MediaType expectedMediaType = MediaType.parse((String)tika.detect(fileName));
        if (!MimeTypeSupport.areMediaTypesRelated(detectedMediaType, expectedMediaType)) {
            logger.error("MIME type mismatch: Source: '{}', Detected: '{}', Expected: '{}' for filename: {}", new Object[]{source.getClass().getSimpleName(), detectedMediaType, expectedMediaType, fileName});
            return CheckResult.ERROR;
        }
        return CheckResult.OK;
    }

    static boolean areMediaTypesRelated(MediaType detectedMediaType, MediaType expectedMediaType) {
        MediaTypeRegistry registry = MimeTypes.getDefaultMimeTypes().getMediaTypeRegistry();
        return detectedMediaType.getBaseType().equals((Object)expectedMediaType.getBaseType()) || registry.isInstanceOf(expectedMediaType, detectedMediaType) || registry.isInstanceOf(detectedMediaType, expectedMediaType);
    }

    private static Set<String> loadRegisteredExtensions() {
        HashSet<String> extensions = new HashSet<String>();
        MimeTypes mimeTypes = MimeTypes.getDefaultMimeTypes();
        for (MediaType mediaType : mimeTypes.getMediaTypeRegistry().getTypes()) {
            try {
                MimeType mimeType = mimeTypes.forName(mediaType.toString());
                mimeType.getExtensions().stream().filter(StringUtils::isNotBlank).map(ext -> StringUtils.removeStart((String)ext, (String)".").toLowerCase()).forEach(extensions::add);
            }
            catch (MimeTypeException mimeTypeException) {}
        }
        return extensions;
    }

    static {
        try {
            tika = new Tika();
            registredExtensions.addAll(MimeTypeSupport.loadRegisteredExtensions());
            MimeType mtOctetStream = MimeTypes.getDefaultMimeTypes().forName(MediaType.OCTET_STREAM.toString());
            knownOctetStreamExtensions.addAll(mtOctetStream.getExtensions().stream().map(ext -> ext.startsWith(".") ? ext.substring(1) : ext).toList());
        }
        catch (Exception e) {
            logger.error("Failed to initialize Apache Tika", (Throwable)e);
        }
    }

    public static enum CheckResult {
        OK,
        WARN,
        ERROR;

    }
}

