/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.file;

import de.riwagis.util.file.TempFileSupport;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FileSupport.class);
    private static final char[] arrNotAllowed = new char[]{'\\', '/', ':', '?', '*', '<', '>', '|', '\n', '\t', '\r'};
    private static final Pattern ILLEGAL_FILENAME_CHARACTERS = Pattern.compile("[\n\t\r?><|:*]+");
    public static final Pattern NORMALIZED_PATTERN = Pattern.compile("[?><|*:/\\\"]+");

    public static final void moveMultipleFiles(String _baseFilename, File _fromDir, File _toDir, String[] _consideredExtensions) throws IOException {
        _fromDir.mkdirs();
        _toDir.mkdirs();
        for (String currExt : _consideredExtensions) {
            FileSupport.moveExistingFile(new File(_fromDir, _baseFilename + currExt), new File(_toDir, _baseFilename + currExt));
        }
    }

    private FileSupport() {
    }

    private static String addLeadingDot(String fileExtension) {
        if (StringUtils.isNotBlank((CharSequence)fileExtension) && !fileExtension.startsWith(".")) {
            return "." + fileExtension;
        }
        return fileExtension;
    }

    public static File addExtension(File dataFile, String extension) {
        String currFilename;
        File resFile = dataFile;
        if (dataFile != null && StringUtils.isNotBlank((CharSequence)extension) && !FilenameUtils.getExtension((String)(currFilename = dataFile.getPath())).equalsIgnoreCase(extension)) {
            resFile = new File(currFilename + FileSupport.addLeadingDot(extension));
        }
        return resFile;
    }

    public static void deleteEmptyDirectories(File dir, Collection<File> successDirectories) {
        FileSupport.deleteEmptyDirectories(dir, successDirectories, null);
    }

    public static void deleteEmptyDirectories(File dir, Collection<File> successDirectories, Collection<File> failDirectories) {
        if (dir != null && dir.isDirectory()) {
            File[] listFiles = dir.listFiles();
            if (listFiles != null) {
                for (File subFile : listFiles) {
                    FileSupport.deleteEmptyDirectories(subFile, successDirectories, failDirectories);
                }
                File[] listFilesRemainingDirs = dir.listFiles();
                if (listFilesRemainingDirs != null) {
                    if (listFilesRemainingDirs.length == 0) {
                        LOG.debug(String.format("Deleting empty directory: '%s'", dir));
                        if (dir.delete()) {
                            if (successDirectories != null) {
                                successDirectories.add(dir);
                            }
                        } else if (failDirectories != null) {
                            failDirectories.add(dir);
                        }
                    }
                } else {
                    LOG.info(String.format("directory '%s' suspect (listFiles returns null, isDirectory: %s)", dir, dir.isDirectory()));
                }
            } else {
                LOG.info(String.format("directory '%s' suspect (listFiles returns null, isDirectory: %s)", dir, dir.isDirectory()));
            }
        }
    }

    public static boolean deleteEmptyDirectories(File dir) {
        LinkedHashSet<File> failDirectories = new LinkedHashSet<File>();
        FileSupport.deleteEmptyDirectories(dir, null, failDirectories);
        return failDirectories.size() > 0;
    }

    public static void mkParentDirs(File f) {
        File parentDir;
        if (f != null && (parentDir = f.getParentFile()) != null && !parentDir.exists()) {
            f.getParentFile().mkdirs();
        }
    }

    public static File createTempDir(String prefix, String suffix) throws IOException {
        File tmpDirRoot = File.createTempFile(prefix, suffix);
        tmpDirRoot.delete();
        tmpDirRoot.mkdirs();
        return tmpDirRoot;
    }

    public static File createFileObject(String fname, File defaultFile) {
        if (fname != null) {
            return new File(fname);
        }
        return defaultFile;
    }

    public static File createFileObject(String fname) {
        return FileSupport.createFileObject(fname, null);
    }

    public static String getPathOfFile(String strFilename) {
        int posSepa = Math.max(strFilename.lastIndexOf(47), strFilename.lastIndexOf(92));
        if (posSepa >= 0) {
            return strFilename.substring(0, posSepa);
        }
        return "";
    }

    public static String getDefaultDir(String strDirname) {
        StringBuffer sbDirname = new StringBuffer(strDirname.trim());
        if (sbDirname.length() > 0 && (sbDirname.charAt(sbDirname.length() - 1) == '\\' || sbDirname.charAt(sbDirname.length() - 1) == '/')) {
            sbDirname.deleteCharAt(sbDirname.length() - 1);
        }
        FileSupport.replaceInStringBuffer(sbDirname, '\\', '/');
        return sbDirname.toString();
    }

    public static boolean exists(String strFilename) {
        File file = new File(strFilename);
        return file.exists();
    }

    private static void replaceInStringBuffer(StringBuffer sb, char search, char replace) {
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != search) continue;
            sb.setCharAt(i, replace);
        }
    }

    public static long getDirectorySize(File dir, boolean includeSubDirs) {
        long lngSize = 0L;
        if (dir.isDirectory()) {
            File[] children = dir.listFiles();
            if (children != null) {
                for (File children1 : children) {
                    lngSize += children1.length();
                    if (!children1.isDirectory() || !includeSubDirs) continue;
                    lngSize += FileSupport.getDirectorySize(children1, includeSubDirs);
                }
            }
        } else {
            lngSize = dir.length();
        }
        return lngSize;
    }

    public static boolean canWriteDirectory(File dir, boolean includeSubDirs) {
        if (dir.isDirectory()) {
            File[] children = dir.listFiles();
            if (children != null) {
                for (File children1 : children) {
                    if (!children1.canWrite() || !FileSupport.canWriteExtended(children1)) {
                        return false;
                    }
                    if (!children1.renameTo(dir) || !children1.isDirectory() || !includeSubDirs || FileSupport.canWriteDirectory(children1, includeSubDirs)) continue;
                    return false;
                }
            }
            return true;
        }
        return dir.canWrite() || FileSupport.canWriteExtended(dir);
    }

    public static boolean canWriteExtended(File file) {
        File fileRename = new File(file.toString() + "_r");
        boolean bolTest = file.renameTo(fileRename);
        if (bolTest) {
            fileRename.renameTo(file);
        }
        return bolTest;
    }

    public static void copyFile(File sourceFile, File destinationFile) throws IOException {
        TempFileSupport.copyFileTemp(sourceFile, destinationFile);
    }

    public static void moveExistingFile(File sourceFile, File destinationFile) throws IOException {
        if (sourceFile.exists()) {
            FileSupport.moveFile(sourceFile, destinationFile);
        }
    }

    public static void moveFile(File sourceFile, File destinationFile) throws IOException {
        try {
            if (destinationFile.exists()) {
                destinationFile.delete();
            }
            FileUtils.moveFile((File)sourceFile, (File)destinationFile);
        }
        catch (IOException e) {
            LOG.error(String.format("Error moving file: '%s'-->'%s': %s", sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath(), e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    public static boolean deleteRecursive(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            for (String children1 : children = dir.list()) {
                boolean success = FileSupport.deleteRecursive(new File(dir, children1));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void cleanDirectory(File pathToClean, long minimumAgeInSeconds, boolean includeSubDirs) {
        long time = System.currentTimeMillis() - 1000L * minimumAgeInSeconds;
        try {
            File[] filesInDir;
            if (pathToClean != null && pathToClean.isDirectory() && (filesInDir = pathToClean.listFiles()) != null) {
                for (File currFile : filesInDir) {
                    if (currFile.isDirectory()) {
                        if (!includeSubDirs) continue;
                        FileSupport.cleanDirectory(currFile, minimumAgeInSeconds, includeSubDirs);
                        String[] remainingFilesInSubDir = currFile.list();
                        if (remainingFilesInSubDir == null || remainingFilesInSubDir.length != 0) continue;
                        try {
                            LOG.debug(String.format("remove empty dir '%s'", currFile));
                            currFile.delete();
                        }
                        catch (Exception e) {
                            LOG.warn(String.format("Error removing empty directory '%s': %s", currFile, e.getMessage()));
                        }
                        continue;
                    }
                    if (currFile.lastModified() >= time) continue;
                    try {
                        LOG.debug(String.format("remove old file '%s'", currFile));
                        currFile.delete();
                    }
                    catch (Exception e) {
                        LOG.warn(String.format("Error removing old file '%s': %s", currFile, e.getMessage()));
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error(String.format("Error cleaning directory '%s': %s", pathToClean, e.getMessage()), (Throwable)e);
        }
    }

    public static FilenameFilter getFilenameFilter(final String[] arrSuffix) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String strName) {
                for (String arrSuffix1 : arrSuffix) {
                    if (!strName.toLowerCase().endsWith(arrSuffix1.toLowerCase())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static String replaceUmlauts(String str2convert) {
        if (str2convert == null) {
            return null;
        }
        String convertedString = Normalizer.normalize(str2convert, Normalizer.Form.NFC);
        convertedString = convertedString.replaceAll("\u00fc", "ue");
        convertedString = convertedString.replaceAll("\u00f6", "oe");
        convertedString = convertedString.replaceAll("\u00e4", "ae");
        convertedString = convertedString.replaceAll("\u00df", "ss");
        convertedString = convertedString.replaceAll("\u00dc", "Ue");
        convertedString = convertedString.replaceAll("\u00d6", "Oe");
        convertedString = convertedString.replaceAll("\u00c4", "Ae");
        return convertedString;
    }

    public static String checkFileName(String strFileName) {
        if (StringUtils.isBlank((CharSequence)strFileName)) {
            throw new IllegalArgumentException("filename is null/empty.");
        }
        String res = FileSupport.replaceUmlauts(strFileName);
        if (StringUtils.containsAny((CharSequence)FilenameUtils.getName((String)res), (char[])arrNotAllowed)) {
            throw new IllegalArgumentException(String.format("filename must not contain following chars: %s", Arrays.toString(arrNotAllowed)));
        }
        return res;
    }

    public static boolean canWrite(File testFile) {
        try {
            if (testFile.exists()) {
                return testFile.canWrite();
            }
            if (testFile.isDirectory()) {
                return false;
            }
            if (testFile.getParentFile() == null || !testFile.getParentFile().exists()) {
                return false;
            }
            testFile.createNewFile();
            testFile.delete();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean canWrite(String strFileOrPath) {
        return FileSupport.canWrite(new File(strFileOrPath));
    }

    public static File findMostRecentFilename(File subDir, String fileMask) {
        WildcardFileFilter filter;
        Object[] files;
        if (subDir.isDirectory() && (files = subDir.listFiles((FilenameFilter)(filter = fileMask != null ? new WildcardFileFilter(fileMask) : null))).length > 0) {
            Arrays.sort(files);
            return files[files.length - 1];
        }
        return null;
    }

    public static final String removeIllegalCharsFromFilename(String filename) {
        if (filename != null) {
            return ILLEGAL_FILENAME_CHARACTERS.matcher(filename).replaceAll(" ");
        }
        return filename;
    }

    public static final boolean isFilesystemRootValid(File file) {
        Objects.requireNonNull(file, "filename is null/empty.");
        boolean isRootValid = false;
        String root = FilenameUtils.getPrefix((String)file.getAbsolutePath());
        if (!StringUtils.isEmpty((CharSequence)root)) {
            for (File f : File.listRoots()) {
                if (!f.getPath().equals(root.toUpperCase())) continue;
                isRootValid = true;
                break;
            }
        } else {
            isRootValid = true;
        }
        return isRootValid;
    }

    public static final boolean isDirectoryValid(File file) {
        Objects.requireNonNull(file, "filename is null/empty.");
        File directoryFile = new File(FilenameUtils.getFullPath((String)file.getAbsolutePath()));
        return directoryFile.isDirectory();
    }

    public static final boolean isFilenameValid(File file) {
        Objects.requireNonNull(file, "filename is null/empty.");
        return !NORMALIZED_PATTERN.matcher(FilenameUtils.getName((String)file.getAbsolutePath())).find();
    }
}

