/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHashContainer {
    private static final Logger LOG = LoggerFactory.getLogger(FileHashContainer.class);
    public static final String MD5SUM_ENCODING = "UTF-8";
    public static final Comparator<FileHashContainer> COMPAREFILENAMES = new Comparator<FileHashContainer>(){

        @Override
        public int compare(FileHashContainer o1, FileHashContainer o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return Collator.getInstance().compare(o1.getFilename(), o2.getFilename());
        }
    };
    private final String filename;
    private final String filehashMD5;
    private static final Pattern MD5SUM = Pattern.compile("^\\s*([a-fA-F0-9]{32})\\s*$");
    private static final Pattern MD5LINE = Pattern.compile("^\\s*([a-fA-F0-9]{32}) \\s*(.*)\\s*$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String calcFileMD5HashCode(File file) throws FileNotFoundException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        String s = null;
        try {
            s = DigestUtils.md5Hex((InputStream)bis);
        }
        catch (IOException ioex) {
            LOG.warn(String.format("Error MD5 File '%s': %s", file, ioex.getMessage()));
            LOG.debug("Error", (Throwable)ioex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bis);
        }
        return s;
    }

    public FileHashContainer(String _filename, String _filehashMD5) {
        if (_filename == null) {
            throw new NullPointerException("filename must not be null");
        }
        if (_filehashMD5 == null) {
            throw new NullPointerException("MD5 must not be null");
        }
        this.filename = _filename;
        Matcher m = MD5SUM.matcher(_filehashMD5);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("not a valid MD5: '%s'", _filehashMD5));
        }
        this.filehashMD5 = m.group(1);
    }

    public final String getFilename() {
        return this.filename;
    }

    public final String getFilehashMD5() {
        return this.filehashMD5;
    }

    public String toString() {
        return String.format("%s  %s", this.getFilehashMD5(), this.getFilename());
    }

    public static Map<String, FileHashContainer> indexByMD5(Collection<FileHashContainer> fileHashes) {
        LinkedHashMap<String, FileHashContainer> res = new LinkedHashMap<String, FileHashContainer>();
        for (FileHashContainer currFileHashContainer : fileHashes) {
            res.put(currFileHashContainer.getFilehashMD5(), currFileHashContainer);
        }
        return res;
    }

    public static Map<String, FileHashContainer> indexByName(Collection<FileHashContainer> fileHashes) {
        LinkedHashMap<String, FileHashContainer> res = new LinkedHashMap<String, FileHashContainer>();
        for (FileHashContainer currFileHashContainer : fileHashes) {
            res.put(currFileHashContainer.getFilename(), currFileHashContainer);
        }
        return res;
    }

    public static Collection<FileHashContainer> readMD5sum(InputStream md5sumStream) throws IOException {
        String currHashLine;
        LinkedHashSet<FileHashContainer> res = new LinkedHashSet<FileHashContainer>();
        BufferedReader rd = new BufferedReader(new InputStreamReader(md5sumStream, MD5SUM_ENCODING));
        int currline = 0;
        while ((currHashLine = rd.readLine()) != null) {
            ++currline;
            if (!StringUtils.isNotBlank((CharSequence)currHashLine)) continue;
            Matcher m = MD5LINE.matcher(currHashLine);
            if (m.matches()) {
                res.add(new FileHashContainer(m.group(2), m.group(1)));
                continue;
            }
            throw new IOException(String.format("Illegal entry in hashFile line: %d: '%s'", currline, currHashLine));
        }
        return res;
    }

    public static Collection<FileHashContainer> readMD5sum(File md5sumFile) throws IOException {
        FileInputStream fileIS = new FileInputStream(md5sumFile);
        try {
            Collection<FileHashContainer> collection = FileHashContainer.readMD5sum(fileIS);
            return collection;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileIS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMD5sum(File md5sumFile, Collection<FileHashContainer> fileHashes) throws IOException {
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(md5sumFile), MD5SUM_ENCODING));
        try {
            for (FileHashContainer currFileHashContainer : fileHashes) {
                wr.write(String.format("%s  %s", currFileHashContainer.getFilehashMD5(), currFileHashContainer.getFilename()));
                wr.newLine();
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)wr);
        }
    }

    public static FileHashContainer findByName(Collection<FileHashContainer> hashes, String _filename) {
        for (FileHashContainer currFileHashContainer : hashes) {
            if (!StringUtils.equals((CharSequence)currFileHashContainer.getFilename(), (CharSequence)_filename)) continue;
            return currFileHashContainer;
        }
        return null;
    }
}

