/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.csv;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class CSVSupport {
    public static String quoteString(String original, String quoteChar, String escapedQuoteChar) {
        if (quoteChar == null || escapedQuoteChar == null) {
            throw new NullPointerException("quotation with NULL quotation not allowed");
        }
        if (original != null && StringUtils.isNotBlank((CharSequence)quoteChar)) {
            String regexQuoteChar = quoteChar.replaceAll("(.)", "\\\\$1");
            String replaceQuoteChar = escapedQuoteChar.replaceAll("\\\\", "\\\\\\\\");
            return quoteChar + original.replaceAll(regexQuoteChar, replaceQuoteChar) + quoteChar;
        }
        return original;
    }

    public static String quoteString(String original, String quoteChar) {
        return CSVSupport.quoteString(original, quoteChar, quoteChar + quoteChar);
    }

    public static String getCsvValue(String originalValue, char strDelim, char strQuote, char strDeci) {
        Object strValue = StringUtils.defaultString((String)originalValue);
        if (CSVSupport.isNumeric((String)strValue)) {
            strValue = ((String)strValue).trim().replaceAll("\\.", Character.toString(strDeci));
        }
        if (StringUtils.containsAny((CharSequence)strValue, (char[])new char[]{strQuote, strDelim, '\n', '\r'})) {
            String doubleQuote = Character.toString(strQuote) + Character.toString(strQuote);
            strValue = strQuote + ((String)strValue).replaceAll("\\" + strQuote, doubleQuote) + strQuote;
        }
        return strValue;
    }

    public static boolean readCsvLine(char chrDelim, char chrMask, Reader csvReader, List<String> lstResult) throws IOException {
        int r;
        lstResult.clear();
        StringBuilder sbResult = new StringBuilder();
        boolean bolInMask = false;
        while ((r = csvReader.read()) != -1) {
            char chr = (char)r;
            if (chr == chrMask) {
                if (bolInMask) {
                    r = csvReader.read();
                    if (r != -1) {
                        chr = (char)r;
                        if (chr == chrMask) {
                            sbResult.append(chrMask);
                            continue;
                        }
                    } else {
                        bolInMask = !bolInMask;
                        break;
                    }
                }
                boolean bl = bolInMask = !bolInMask;
            }
            if (chr == '\r') {
                if (!bolInMask) continue;
                sbResult.append(chr);
                continue;
            }
            if (chr == '\n') {
                if (!bolInMask) break;
                sbResult.append(chr);
                continue;
            }
            if (chr == chrDelim && !bolInMask) {
                lstResult.add(sbResult.toString());
                sbResult.setLength(0);
                continue;
            }
            if (chr == chrMask) continue;
            sbResult.append(String.valueOf(chr));
        }
        lstResult.add(sbResult.toString());
        if (bolInMask) {
            throw new IOException(String.format("unclosed csv-line", 1));
        }
        return r == -1;
    }

    public static String buildCSVTitleLine(List<String> headings, char separator, char quote, char strdeci) {
        ArrayList<String> fieldContent = new ArrayList<String>();
        for (String currCSVString : headings) {
            fieldContent.add(CSVSupport.getCsvValue(currCSVString, separator, quote, strdeci));
        }
        return StringUtils.join(fieldContent, (char)separator);
    }

    public static String buildCSVDataLine(List<String> headings, Map<String, String> dataStrings, char separator, char quote, char strdeci) {
        StringBuilder res = new StringBuilder();
        boolean first = true;
        for (String currTitleString : headings) {
            if (!first) {
                res.append(separator);
            }
            first = false;
            res.append(CSVSupport.getCsvValue(StringUtils.defaultString((String)dataStrings.get(currTitleString), (String)""), separator, quote, strdeci));
        }
        return res.toString();
    }

    @Deprecated
    public static void writeCSVFile(File outFile, List<String> headerList, List<Map<String, String>> dataList, char separator, char quote, char strdeci) throws IOException {
        CSVSupport.writeCSVFile(outFile, Charset.defaultCharset(), headerList, dataList, separator, quote, strdeci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCSVFile(File outFile, Charset cs, List<String> headerList, List<Map<String, String>> dataList, char separator, char quote, char strdeci) throws IOException {
        FileOutputStream w = new FileOutputStream(outFile);
        try {
            CSVSupport.writeCSVFile(w, cs, headerList, dataList, separator, quote, strdeci);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)w);
        }
    }

    public static void writeCSVFile(Writer outWriter, List<String> headerList, List<Map<String, String>> dataList, char separator, char quote, char strdeci) throws IOException {
        PrintWriter b = outWriter instanceof PrintWriter ? (PrintWriter)outWriter : new PrintWriter(outWriter);
        b.println(CSVSupport.buildCSVTitleLine(headerList, separator, quote, strdeci));
        for (Map<String, String> currEntry : dataList) {
            b.println(CSVSupport.buildCSVDataLine(headerList, currEntry, separator, quote, strdeci));
        }
        b.flush();
    }

    public static void writeCSVFile(OutputStream outStream, Charset cs, List<String> headerList, List<Map<String, String>> dataList, char separator, char quote, char strdeci) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(outStream, cs);
        CSVSupport.writeCSVFile(w, headerList, dataList, separator, quote, strdeci);
    }

    public static boolean isNumeric(String tf) {
        return NumberUtils.isNumber((String)StringUtils.trim((String)tf));
    }

    private CSVSupport() {
    }
}

