/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.csv.parse;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import com.opencsv.exceptions.CsvValidationException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.geotools.data.csv.CSVFileState;
import org.geotools.data.csv.parse.CSVStrategy;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;

public class CSVLatLonStrategy
extends CSVStrategy {
    public static final DefaultGeographicCRS _CRS = DefaultGeographicCRS.WGS84;
    private String latField;
    private String lngField;
    private String pointField;

    public CSVLatLonStrategy(CSVFileState csvFileState) {
        this(csvFileState, null, null);
    }

    public CSVLatLonStrategy(CSVFileState csvFileState, String latField, String lngField) {
        this(csvFileState, latField, lngField, "location");
    }

    public CSVLatLonStrategy(CSVFileState csvFileState, String latField, String lngField, String pointField) {
        super(csvFileState);
        this.latField = latField;
        this.lngField = lngField;
        this.pointField = pointField;
    }

    @Override
    protected SimpleFeatureType buildFeatureType() {
        Map<String, Class<?>> typesFromData;
        String[] headers;
        try {
            String[] stringArray = null;
            try (CSVReader csvReader = this.csvFileState.openCSVReader();){
                headers = this.csvFileState.getCSVHeaders();
                typesFromData = CSVLatLonStrategy.findMostSpecificTypesFromData(csvReader, headers);
            }
            catch (Throwable object) {
                stringArray = object;
                throw object;
            }
        }
        catch (CsvValidationException | IOException e) {
            throw new RuntimeException(e);
        }
        SimpleFeatureTypeBuilder builder = CSVLatLonStrategy.createBuilder(this.csvFileState, headers, typesFromData);
        if (this.latField == null || this.lngField == null) {
            for (String col : headers) {
                if (this.isLatitude(col)) {
                    this.latField = col;
                    continue;
                }
                if (!this.isLongitude(col)) continue;
                this.lngField = col;
            }
        }
        Class<?> latClass = typesFromData.get(this.latField);
        Class<?> lngClass = typesFromData.get(this.lngField);
        if (CSVLatLonStrategy.isNumeric(latClass) && CSVLatLonStrategy.isNumeric(lngClass)) {
            List<String> csvHeaders = Arrays.asList(headers);
            int index = csvHeaders.indexOf(this.latField);
            AttributeTypeBuilder builder2 = new AttributeTypeBuilder();
            builder2.setCRS(_CRS);
            builder2.binding(Point.class);
            AttributeDescriptor descriptor = builder2.buildDescriptor(this.pointField);
            builder.add(index, descriptor);
            builder.remove(this.latField);
            builder.remove(this.lngField);
        }
        return builder.buildFeatureType();
    }

    private boolean isLatitude(String s) {
        return "latitude".equalsIgnoreCase(s) || "lat".equalsIgnoreCase(s);
    }

    private boolean isLongitude(String s) {
        return "lon".equalsIgnoreCase(s) || "lng".equalsIgnoreCase(s) || "long".equalsIgnoreCase(s) || "longitude".equalsIgnoreCase(s);
    }

    protected static boolean isNumeric(Class<?> clazz) {
        return clazz != null && (clazz == Double.class || clazz == Integer.class);
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        CoordinateReferenceSystem crs;
        this.featureType = featureType;
        ArrayList<String> header = new ArrayList<String>();
        GeometryDescriptor gd = featureType.getGeometryDescriptor();
        CoordinateReferenceSystem coordinateReferenceSystem = crs = gd != null ? gd.getCoordinateReferenceSystem() : null;
        if (gd != null && CRS.equalsIgnoreMetadata(_CRS, crs) && gd.getType().getBinding().isAssignableFrom(Point.class)) {
            if (crs.getCoordinateSystem().getAxis(0).getDirection().equals((Object)AxisDirection.NORTH)) {
                header.add(this.latField);
                header.add(this.lngField);
            } else {
                header.add(this.lngField);
                header.add(this.latField);
            }
        } else {
            throw new IOException("Unable use " + this.latField + "/" + this.lngField + " to represent " + gd);
        }
        for (AttributeDescriptor descriptor : featureType.getAttributeDescriptors()) {
            if (descriptor instanceof GeometryDescriptor) continue;
            header.add(descriptor.getLocalName());
        }
        try (CSVWriter writer = new CSVWriter((Writer)new FileWriter(this.csvFileState.getFile()), this.getSeparator(), this.getQuotechar(), this.getEscapechar(), this.getLineSeparator());){
            writer.writeNext(header.toArray(new String[header.size()]), this.isQuoteAllFields());
        }
    }

    @Override
    public SimpleFeature decode(String recordId, String[] csvRecord) {
        SimpleFeatureType featureType = this.getFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        GeometryDescriptor geometryDescriptor = featureType.getGeometryDescriptor();
        GeometryFactory geometryFactory = new GeometryFactory();
        Double lat = null;
        Double lng = null;
        String[] headers = this.csvFileState.getCSVHeaders();
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            if (i < csvRecord.length) {
                String value = csvRecord[i].trim();
                LOGGER.fine("Processing " + header + " with value of " + value);
                if (geometryDescriptor != null && header.equals(this.latField)) {
                    lat = Double.valueOf(value);
                    continue;
                }
                if (geometryDescriptor != null && header.equals(this.lngField)) {
                    lng = Double.valueOf(value);
                    continue;
                }
                if (!value.isEmpty()) {
                    builder.set(header, (Object)value);
                    continue;
                }
                builder.set(header, null);
                continue;
            }
            LOGGER.warning("record had fewer values than header");
            if (csvRecord.length == 1 && csvRecord[0].isEmpty()) {
                return null;
            }
            builder.set(header, null);
        }
        if (geometryDescriptor != null && lat != null && lng != null) {
            Coordinate coordinate = geometryDescriptor.getCoordinateReferenceSystem().getCoordinateSystem().getAxis(0).getDirection().equals((Object)AxisDirection.EAST) ? new Coordinate(lng.doubleValue(), lat.doubleValue()) : new Coordinate(lat.doubleValue(), lng.doubleValue());
            Point point = geometryFactory.createPoint(coordinate);
            builder.set(geometryDescriptor.getLocalName(), (Object)point);
        }
        return builder.buildFeature(this.csvFileState.getTypeName() + "-" + recordId);
    }

    @Override
    public String[] encode(SimpleFeature feature) {
        ArrayList<String> csvRecord = new ArrayList<String>();
        String[] headers = this.csvFileState.getCSVHeaders();
        int latIndex = 0;
        int lngIndex = 0;
        for (int i = 0; i < headers.length; ++i) {
            if (headers[i].equalsIgnoreCase(this.latField)) {
                latIndex = i;
            }
            if (!headers[i].equalsIgnoreCase(this.lngField)) continue;
            lngIndex = i;
        }
        for (Property property : feature.getProperties()) {
            Object value = property.getValue();
            if (value == null) {
                csvRecord.add("");
                continue;
            }
            if (value instanceof Point) {
                Point point = (Point)value;
                if (lngIndex < latIndex) {
                    csvRecord.add(Double.toString(point.getY()));
                    csvRecord.add(Double.toString(point.getX()));
                    continue;
                }
                csvRecord.add(Double.toString(point.getX()));
                csvRecord.add(Double.toString(point.getY()));
                continue;
            }
            String txt = value.toString();
            csvRecord.add(txt);
        }
        return csvRecord.toArray(new String[csvRecord.size() - 1]);
    }
}

