/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class FirstPartExtractorReader
extends FilterReader {
    private final StringBuffer c;
    private final int limit;

    public FirstPartExtractorReader(Reader in, int _limit) {
        super(in);
        this.c = _limit < 100 ? new StringBuffer(_limit) : new StringBuffer();
        this.limit = _limit;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int res = super.read(cbuf, off, len);
        if (res > 0) {
            this.c.append(cbuf, 0, Math.min(res, this.limit - this.c.length()));
        }
        return res;
    }

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (this.c.length() < this.limit) {
            this.c.append((char)res);
        }
        return res;
    }

    public String getPart() {
        return this.c.toString();
    }

    public int getPartLength() {
        return this.c.length();
    }
}

