/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.service.stream;

import de.riwagis.service.StreamProcessor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class FileStreamProcessor
implements StreamProcessor<File> {
    private final File expFile;

    public FileStreamProcessor(File expFile) {
        this.expFile = expFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File processStream(InputStream in) throws IOException {
        try {
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.expFile);
                 BufferedOutputStream fos = new BufferedOutputStream(fileOutputStream);){
                IOUtils.copy((InputStream)in, (OutputStream)fos);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            return this.expFile;
        }
        catch (Exception e) {
            throw new IOException(String.format("error processing stream: %s", e.getMessage()), e);
        }
    }
}

