/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.service.stream;

import de.riwagis.service.StreamProcessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class ByteArrayStreamProcessor
implements StreamProcessor<byte[]> {
    @Override
    public byte[] processStream(InputStream in) throws IOException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                IOUtils.copy((InputStream)in, (OutputStream)bout);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)bout);
            }
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new IOException("error processing stream: " + e.getMessage(), e);
        }
    }
}

