/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.service.directory;

import de.riwagis.service.directory.Directory;
import de.riwagis.service.directory.ProjectType;
import java.io.File;
import java.util.Optional;
import java.util.ServiceLoader;

public class DirectoryService {
    private static DirectoryService service;
    private final ServiceLoader<Directory> loader = ServiceLoader.load(Directory.class);

    private DirectoryService() {
    }

    public static synchronized DirectoryService getInstance() {
        if (service == null) {
            service = new DirectoryService();
        }
        return service;
    }

    public File getApplicationDataLocalDirectory() {
        Optional<Directory> d = this.loader.findFirst();
        return d.get().getApplicationDataLocalDirectory();
    }

    public File getApplicationDataDirectory() {
        Optional<Directory> d = this.loader.findFirst();
        return d.get().getApplicationDataDirectory();
    }

    public File getProjectDirectory(ProjectType prjType) {
        if (prjType == null) {
            throw new IllegalArgumentException("Project type must not be null!");
        }
        Optional<Directory> d = this.loader.findFirst();
        return d.get().getProjectDirectory(prjType);
    }

    public File getProjectCacheDirectory(ProjectType prjType) {
        if (prjType == null) {
            throw new IllegalArgumentException("Project type must not be null!");
        }
        Optional<Directory> d = this.loader.findFirst();
        return d.get().getCacheDirectory(prjType);
    }

    public File getProjectTempDirectory(ProjectType prjType) {
        if (prjType == null) {
            throw new IllegalArgumentException("Project type must not be null!");
        }
        Optional<Directory> d = this.loader.findFirst();
        return d.get().getTempDirecotry(prjType);
    }

    public File getProjectLogDirectory(ProjectType prjType) {
        if (prjType == null) {
            throw new IllegalArgumentException("Project type must not be null!");
        }
        Optional<Directory> d = this.loader.findFirst();
        return d.get().getLogDirectory(prjType);
    }

    public void setProjectLogDirectory(File logDirectory, ProjectType prjType) {
        if (logDirectory == null || prjType == null) {
            throw new IllegalArgumentException("Parameters must not be null!");
        }
        Optional<Directory> d = this.loader.findFirst();
        d.get().setLogDirectory(logDirectory, prjType);
    }

    public File getProjectProxyDirectory() {
        Optional<Directory> d = this.loader.findFirst();
        return d.get().getProxyDirectory();
    }
}

