/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.service.directory;

import de.riwagis.service.directory.Directory;
import de.riwagis.service.directory.ProjectType;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.keyvalue.MultiKey;

public class DirectoryProvider
implements Directory {
    public static final String NAME_COMPANY = "Riwa GmbH";
    private final File LOCAL_APPDATA_DIR = System.getenv("LOCALAPPDATA") == null ? new File(System.getProperty("user.home"), ".riwa") : new File(System.getenv("LOCALAPPDATA"), "Riwa GmbH");
    private final File APPDATA_DIR = System.getenv("APPDATA") == null ? new File(System.getProperty("user.home"), ".riwa") : new File(System.getenv("APPDATA"), "Riwa GmbH");
    private final String CACHE = "cache";
    private final String LOG = "logs";
    private final String TEMP = "temp";
    private final String PROXY = "proxy";
    private final Map<MultiKey, File> directoryMap = new HashMap<MultiKey, File>();

    @Override
    public File getApplicationDataLocalDirectory() {
        return this.LOCAL_APPDATA_DIR;
    }

    @Override
    public File getApplicationDataDirectory() {
        return this.APPDATA_DIR;
    }

    @Override
    public File getProjectDirectory(ProjectType prjType) {
        MultiKey key = new MultiKey((Object)prjType.getDirectoryName(), (Object)"");
        if (!this.directoryMap.containsKey(key)) {
            this.directoryMap.put(key, new File(this.LOCAL_APPDATA_DIR, prjType.getDirectoryName()));
        }
        return this.directoryMap.get(key);
    }

    @Override
    public File getCacheDirectory(ProjectType prjType) {
        MultiKey key = new MultiKey((Object)"cache", (Object)prjType.getDirectoryName());
        if (!this.directoryMap.containsKey(key)) {
            File cacheFile = new File(this.LOCAL_APPDATA_DIR, prjType.getDirectoryName());
            this.directoryMap.put(key, new File(cacheFile, "cache"));
        }
        return this.directoryMap.get(key);
    }

    @Override
    public void setLogDirectory(File logDirectory, ProjectType prjType) {
        this.directoryMap.put(new MultiKey((Object)"logs", (Object)prjType.getDirectoryName()), logDirectory);
    }

    @Override
    public File getLogDirectory(ProjectType prjType) {
        MultiKey key = new MultiKey((Object)"logs", (Object)prjType.getDirectoryName());
        if (!this.directoryMap.containsKey(key)) {
            File logFile = new File(this.LOCAL_APPDATA_DIR, prjType.getDirectoryName());
            this.directoryMap.put(key, new File(logFile, "logs"));
        }
        return this.directoryMap.get(key);
    }

    @Override
    public File getTempDirecotry(ProjectType prjType) {
        MultiKey key = new MultiKey((Object)"temp", (Object)prjType.getDirectoryName());
        if (!this.directoryMap.containsKey(key)) {
            File tmpFile = new File(this.LOCAL_APPDATA_DIR, prjType.getDirectoryName());
            this.directoryMap.put(key, new File(tmpFile, "temp"));
        }
        return this.directoryMap.get(key);
    }

    @Override
    public File getProxyDirectory() {
        MultiKey key = new MultiKey((Object)"proxy", (Object)"");
        if (!this.directoryMap.containsKey(key)) {
            this.directoryMap.put(key, new File(this.APPDATA_DIR, ProjectType.PROXY.getDirectoryName()));
        }
        return this.directoryMap.get(key);
    }
}

