/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.service;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.security.ArrayTypePermission;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import de.riwagis.service.MethodMData;
import de.riwagis.service.ParameterMData;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.util.io.FirstPartExtractorReader;
import de.riwagis.util.xstream.ByteArrayInputStreamConverter;
import de.riwagis.util.xstream.EmptyMapConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceSupport {
    public static final Charset STANDARD_SERVICE_CHARSET = StandardCharsets.UTF_8;
    public static final Collection<String> EMPTY_NOPROXY = Collections.unmodifiableCollection(new HashSet());
    public static final String SVC_CONTENT = "svc_content";
    public static final String SVC_METHOD = "svc_method";
    public static final String SVC_NAME = "svc_name";
    public static final String SVC_VERSION = "svc_version";
    private static final Logger LOG = LoggerFactory.getLogger(ServiceSupport.class);
    private static final XStream xstream = ServiceSupport.createSecuredXStream();

    private ServiceSupport() {
    }

    public static CloseableHttpResponse queryServer(CloseableHttpClient client, HttpContext httpContext, HttpUriRequest svcPost) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("executing service-request: URI: '%s', Params: '%s'", svcPost.getURI(), svcPost.getRequestLine()));
        }
        return client.execute(svcPost, httpContext);
    }

    public static void fillServiceRequest(CloseableHttpResponse svcResponse, MethodMData svcMeth, ServiceRequest<?> srvReq) throws ServiceException {
        block13: {
            HttpEntity entity;
            block14: {
                LOG.debug(String.format("Response: %s", new Object[]{svcMeth.getResponseType()}));
                entity = svcResponse.getEntity();
                if (svcMeth.getResponseType() != MethodMData.MethodResponseType.RETURN_OBJECT) break block14;
                FirstPartExtractorReader myProxyReader = null;
                try {
                    myProxyReader = new FirstPartExtractorReader(new InputStreamReader(entity.getContent(), ContentType.parse((String)entity.getContentType().getValue()).getCharset()), 5000);
                    Object objResponse = xstream.fromXML((Reader)myProxyReader);
                    srvReq.setResult(objResponse);
                }
                catch (IOException | UnsupportedOperationException | UnsupportedCharsetException | ParseException ex) {
                    try {
                        String firstPart = myProxyReader != null ? myProxyReader.getPart() : "";
                        throw new ServiceException(String.format("Error creating response-object from web-server-response: '%s'", firstPart), ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(myProxyReader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Reader)myProxyReader);
                break block13;
            }
            try (InputStream contentStream = entity.getContent();){
                srvReq.setResult(contentStream);
                if (srvReq.hasStreamProcessor()) {
                    srvReq.processStream();
                    break block13;
                }
                throw new ServiceException("No stream processor set for request.");
            }
            catch (IOException | UnsupportedOperationException ex) {
                throw new ServiceException(String.format("Error creating response-object from web-server-response: %s", ex.getMessage()), ex);
            }
        }
    }

    public static CloseableHttpResponse executeWebgisServiceRequest(CloseableHttpClient client, ServiceRequest<?> srvReq, String strURL) throws ServiceException, IOException {
        return ServiceSupport.executeWebgisServiceRequest(client, EMPTY_NOPROXY, srvReq, strURL);
    }

    public static CloseableHttpResponse executeWebgisServiceRequest(CloseableHttpClient client, Collection<String> setNoProxy, ServiceRequest<?> srvReq, String strURL) throws ServiceException, IOException {
        BasicHttpContext httpContext = new BasicHttpContext();
        return ServiceSupport.executeWebgisServiceRequest(client, (HttpContext)httpContext, srvReq, strURL);
    }

    public static final String compressString(String str) throws IOException {
        if (str == null) {
            return null;
        }
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            byte[] arrStr = str.getBytes(STANDARD_SERVICE_CHARSET);
            try (ByteArrayInputStream bin = new ByteArrayInputStream(arrStr);
                 GZIPOutputStream zout = new GZIPOutputStream(bout);){
                int count;
                byte[] data = new byte[512];
                while ((count = ((InputStream)bin).read(data, 0, 512)) != -1) {
                    zout.write(data, 0, count);
                }
            }
            String string = new String(new Base64().encode(bout.toByteArray()));
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpResponse executeWebgisServiceRequest(CloseableHttpClient client, HttpContext httpContext, ServiceRequest<?> srvReq, String strURL) throws ServiceException, IOException {
        CloseableHttpResponse httpResponse;
        block29: {
            RequestBuilder requestBuilder = RequestBuilder.post((String)strURL);
            httpResponse = null;
            try {
                ServiceMData svc = srvReq.getSerice();
                if (svc == null) {
                    throw new ServiceException("No service found.");
                }
                MethodMData svcMeth = svc.getMethod(srvReq.getMethodName());
                if (svcMeth.getHttpType() == MethodMData.MethodHTTPType.HTTP_POST_REQUEST) {
                    HashMap<String, Object> mapContent = new HashMap<String, Object>();
                    mapContent.put(SVC_NAME, svc.getName());
                    mapContent.put(SVC_METHOD, svcMeth.getName());
                    mapContent.put(SVC_VERSION, "" + svc.getVersion());
                    for (String strParamName : srvReq.getParameters().keySet()) {
                        mapContent.put(strParamName, srvReq.getParameters().get(strParamName));
                    }
                    ArrayList<NameValuePair> formParams = new ArrayList<NameValuePair>();
                    String xmlContent = ServiceSupport.convertToXML(xstream, mapContent);
                    formParams.add((NameValuePair)new BasicNameValuePair(SVC_CONTENT, ServiceSupport.compressString(xmlContent)));
                    UrlEncodedFormEntity entity = ServiceSupport.encodeFormEntity(formParams);
                    requestBuilder.setEntity((HttpEntity)entity);
                } else {
                    Map<String, Object> mapParam = srvReq.getParameters();
                    MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
                    multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                    multipartEntityBuilder.addTextBody(SVC_NAME, svc.getName(), ContentType.create((String)"text/plain", (Charset)STANDARD_SERVICE_CHARSET));
                    multipartEntityBuilder.addTextBody(SVC_METHOD, svcMeth.getName(), ContentType.create((String)"text/plain", (Charset)STANDARD_SERVICE_CHARSET));
                    multipartEntityBuilder.addTextBody(SVC_VERSION, "" + svc.getVersion(), ContentType.create((String)"text/plain", (Charset)STANDARD_SERVICE_CHARSET));
                    for (String strParamName : mapParam.keySet()) {
                        ParameterMData svcParam = svcMeth.getParameter(strParamName);
                        if (svcParam == null) {
                            throw new ServiceException("Parameter " + strParamName + " not found.");
                        }
                        Class<?> paramClass = svcParam.getParamClass();
                        Object mapParamValue = mapParam.get(strParamName);
                        if (paramClass.equals(File.class)) {
                            if (mapParamValue == null) continue;
                            File uploadFile = (File)mapParamValue;
                            multipartEntityBuilder.addBinaryBody(strParamName, uploadFile, ContentType.create((String)"application/octet-stream", (Charset)STANDARD_SERVICE_CHARSET), "");
                            continue;
                        }
                        if (paramClass.equals(List.class) && mapParamValue != null && !((List)mapParamValue).isEmpty() && ((List)mapParamValue).get(0) instanceof File) {
                            List files = (List)mapParamValue;
                            for (File file : files) {
                                multipartEntityBuilder.addBinaryBody(strParamName, file, ContentType.create((String)"application/octet-stream", (Charset)STANDARD_SERVICE_CHARSET), "");
                            }
                            continue;
                        }
                        if (svcParam.getParamClass().equals(InputStream.class)) {
                            ByteArrayInputStream bin;
                            Class<?> paramValueClass = mapParamValue.getClass();
                            if (paramValueClass.equals(ByteArrayInputStream.class)) {
                                bin = (ByteArrayInputStream)mapParamValue;
                            } else {
                                try (ByteArrayOutputStream bout = new ByteArrayOutputStream();
                                     InputStream in = (InputStream)mapParam.get(strParamName);){
                                    IOUtils.copy((InputStream)in, (OutputStream)bout);
                                    bin = new ByteArrayInputStream(bout.toByteArray());
                                }
                                catch (IOException ex) {
                                    throw new ServiceException(String.format("unable to read response: %s", ex.getMessage()), ex);
                                }
                            }
                            multipartEntityBuilder.addBinaryBody(strParamName, (InputStream)bin, ContentType.create((String)"application/octet-stream", (Charset)STANDARD_SERVICE_CHARSET), strParamName);
                            continue;
                        }
                        multipartEntityBuilder.addTextBody(strParamName, mapParamValue.toString(), ContentType.create((String)"text/plain", (Charset)STANDARD_SERVICE_CHARSET));
                    }
                    HttpEntity me = multipartEntityBuilder.build();
                    requestBuilder.setEntity(me);
                }
                httpResponse = ServiceSupport.queryServer(client, httpContext, requestBuilder.build());
                int status = httpResponse.getStatusLine().getStatusCode();
                LOG.debug(String.format("ServiceRequest status: %d", status));
                if (status == 200) {
                    ServiceSupport.fillServiceRequest(httpResponse, svcMeth, srvReq);
                    break block29;
                }
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(httpResponse);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)httpResponse);
        return httpResponse;
    }

    private static String convertToXML(XStream xstream, Map<String, Object> mapContent) throws IOException {
        try (StringWriter stringWriter = new StringWriter();){
            xstream.marshal(mapContent, (HierarchicalStreamWriter)new CompactWriter((Writer)stringWriter));
            String string = stringWriter.toString();
            return string;
        }
    }

    private static UrlEncodedFormEntity encodeFormEntity(List<NameValuePair> formParams) throws ServiceException {
        try {
            return new UrlEncodedFormEntity(formParams);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ServiceException(String.format("unable to encode formParams: %s", ex.getMessage()), ex);
        }
    }

    public static final Integer readInteger(Map<String, Object> params, String parameterName) {
        return ServiceSupport.readInteger(params, parameterName, null);
    }

    public static final Integer readInteger(Map<String, Object> params, String parameterName, Integer defaultValue) {
        Integer res = defaultValue;
        Object value = params.get(parameterName);
        if (value != null) {
            if (value instanceof Integer) {
                res = (Integer)value;
            } else if (value instanceof Number) {
                res = ((Number)value).intValue();
            } else {
                try {
                    res = Integer.parseInt(ObjectUtils.toString((Object)value));
                }
                catch (NumberFormatException nfex) {
                    LOG.debug(String.format("Illegal number '%s': %s", value, nfex.toString()), (Throwable)nfex);
                }
            }
        }
        return res;
    }

    public static final String readString(Map<String, Object> params, String parameterName) {
        return ServiceSupport.readString(params, parameterName, null);
    }

    public static final String readString(Map<String, Object> params, String parameterName, String defaultValue) {
        Object value = params.get(parameterName);
        if (value instanceof String) {
            return (String)value;
        }
        return ObjectUtils.toString((Object)value, (String)defaultValue);
    }

    public static final Boolean readBoolean(Map<String, Object> params, String parameterName) {
        return ServiceSupport.readBoolean(params, parameterName, null);
    }

    public static final Boolean readBoolean(Map<String, Object> params, String parameterName, Boolean defaultValue) {
        Object value = params.get(parameterName);
        if (value instanceof Boolean) {
            return BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)value), (boolean)defaultValue);
        }
        Boolean res = BooleanUtils.toBooleanObject((String)ObjectUtils.toString((Object)value));
        return res == null ? defaultValue : res;
    }

    private static XStream createSecuredXStream() {
        XStream xstream = new XStream();
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission(NullPermission.NULL);
        xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xstream.addPermission(ArrayTypePermission.ARRAYS);
        xstream.allowTypeHierarchy(Collection.class);
        xstream.allowTypeHierarchy(Map.class);
        xstream.allowTypeHierarchy(Date.class);
        xstream.allowTypes(new Class[]{String.class, URI.class, File.class, BigInteger.class, BigDecimal.class});
        xstream.registerConverter((Converter)new ByteArrayInputStreamConverter());
        xstream.registerConverter((Converter)new EmptyMapConverter());
        return xstream;
    }
}

