/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.service;

import de.riwagis.service.ServiceMData;
import de.riwagis.service.StreamProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class ServiceRequest<T> {
    private final ServiceMData svc;
    private final String strMethod;
    private final Map<String, Object> mapParam = new HashMap<String, Object>();
    private Object objResult = null;
    private String strError = null;
    private StreamProcessor<T> streamProc = null;

    ServiceRequest(ServiceMData _svc, String _strMethod, Map<String, Object> _mapParam) {
        this.svc = _svc;
        this.strMethod = _strMethod;
        this.mapParam.clear();
        this.mapParam.putAll(_mapParam);
    }

    public ServiceMData getSerice() {
        return this.svc;
    }

    public String getSericeName() {
        return this.svc.getName();
    }

    public String getMethodName() {
        return this.strMethod;
    }

    public int getVersion() {
        return this.svc.getVersion();
    }

    public Map<String, Object> getParameters() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.putAll(this.mapParam);
        return res;
    }

    public Object getParameter(String name) {
        return this.mapParam.get(name);
    }

    public void setResult(Object obj) {
        this.objResult = obj;
    }

    public T getResult() {
        return (T)this.objResult;
    }

    public void setStreamProcessor(StreamProcessor<T> _streamProc) {
        this.streamProc = _streamProc;
    }

    public boolean hasStreamProcessor() {
        return this.streamProc != null;
    }

    public void processStream() throws IOException {
        this.objResult = this.streamProc.processStream((InputStream)this.objResult);
    }

    public void setError(String _strError) {
        this.strError = _strError;
    }

    public String getError() {
        return this.strError;
    }

    public boolean hasError() {
        return this.strError != null;
    }
}

