/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.service;

import de.riwagis.service.MethodMData;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceRequest;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ServiceMData {
    public static final Map<String, Object> EMPTY_PARAMATERS = Collections.EMPTY_MAP;
    private final String strName;
    private final int intVersion;
    private final Map<String, MethodMData> arrMethods = new LinkedHashMap<String, MethodMData>();

    public ServiceMData(String _strName, int _intVersion, MethodMData[] _arrMethods) {
        this.strName = _strName;
        this.intVersion = _intVersion;
        for (MethodMData currMethod : _arrMethods) {
            this.arrMethods.put(currMethod.getName(), currMethod);
        }
    }

    public int getVersion() {
        return this.intVersion;
    }

    public String getName() {
        return this.strName;
    }

    public Iterator<MethodMData> getMethods() {
        return Collections.unmodifiableCollection(this.arrMethods.values()).iterator();
    }

    public MethodMData getMethod(String strMethod) {
        return this.arrMethods.get(strMethod);
    }

    public boolean equals(Object obj) {
        ServiceMData svcObj;
        return obj instanceof ServiceMData && (svcObj = (ServiceMData)obj).getVersion() == this.intVersion && svcObj.getName().equals(this.strName);
    }

    public <M> ServiceRequest<M> createRequest(String strMethod) throws ServiceException {
        return this.createRequest(strMethod, EMPTY_PARAMATERS);
    }

    public <M> ServiceRequest<M> createRequest(String strMethod, Map<String, Object> params) throws ServiceException {
        MethodMData meth = this.getMethod(strMethod);
        if (meth == null) {
            throw new ServiceException("Method not found");
        }
        return new ServiceRequest(this, meth.getName(), params);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.strName != null ? this.strName.hashCode() : 0);
        hash = 31 * hash + this.intVersion;
        return hash;
    }

    public String toString() {
        return String.format("Service '%s' (Version: %d, Methods: %s)", this.getName(), this.getVersion(), this.arrMethods);
    }
}

