/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.service;

import de.riwagis.service.ParameterMData;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MethodMData {
    private final String strName;
    private final MethodHTTPType httpType;
    private final MethodResponseType responseType;
    private final Map<String, ParameterMData> arrParameters = new LinkedHashMap<String, ParameterMData>();

    public MethodMData(String _strName, ParameterMData[] _arrParameters, MethodHTTPType _httpType, MethodResponseType _responseType) {
        if (_arrParameters != null) {
            for (ParameterMData currParameter : _arrParameters) {
                this.arrParameters.put(currParameter.getName(), currParameter);
            }
        }
        this.strName = _strName;
        this.httpType = _httpType;
        this.responseType = _responseType;
    }

    public String getName() {
        return this.strName;
    }

    public MethodHTTPType getHttpType() {
        return this.httpType;
    }

    public MethodResponseType getResponseType() {
        return this.responseType;
    }

    public Iterator<ParameterMData> getParameters() {
        return Collections.unmodifiableCollection(this.arrParameters.values()).iterator();
    }

    public ParameterMData getParameter(String strName) {
        return this.arrParameters.get(strName);
    }

    public String toString() {
        return String.format("Method: '%s', Parameters: %s", this.getName(), this.arrParameters);
    }

    public static enum MethodHTTPType {
        HTTP_POST_REQUEST,
        HTTP_MULTIPART_REQUEST,
        HTTP_UNKNOWN_REQUEST;

    }

    public static enum MethodResponseType {
        RETURN_OBJECT,
        RETURN_STREAM,
        RETURN_UNKNOWN;

    }
}

