/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.service;

import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceProvider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractServiceProvider
implements ServiceProvider {
    private final List<ActionListener> lstLogoutListeners = new ArrayList<ActionListener>();
    private final List<ActionListener> lstLoginListeners = new ArrayList<ActionListener>();
    private String subUser;

    protected void fireLoginListeners() {
        ActionEvent e = new ActionEvent(this, -1, "login");
        for (ActionListener l : this.lstLoginListeners) {
            l.actionPerformed(e);
        }
    }

    protected void fireLogoutListeners() {
        ActionEvent e = new ActionEvent(this, -1, "logout");
        for (ActionListener l : this.lstLogoutListeners) {
            l.actionPerformed(e);
        }
    }

    @Override
    public boolean doReLogin() throws ServiceException {
        this.doLogout();
        this.setSubUser(null);
        return this.doLogin();
    }

    @Override
    public void addLogoutListener(ActionListener listener) {
        if (!this.lstLogoutListeners.contains(listener)) {
            this.lstLogoutListeners.add(listener);
        }
    }

    @Override
    public void addLoginListener(ActionListener listener) {
        if (!this.lstLoginListeners.contains(listener)) {
            this.lstLoginListeners.add(listener);
        }
    }

    public void removeLogoutListener(ActionListener listener) {
        if (this.lstLogoutListeners.contains(listener)) {
            this.lstLogoutListeners.remove(listener);
        }
    }

    public void removeLoginListener(ActionListener listener) {
        if (this.lstLoginListeners.contains(listener)) {
            this.lstLoginListeners.remove(listener);
        }
    }

    @Override
    public String getSubUser() {
        return this.subUser;
    }

    @Override
    public void setSubUser(String subUser) {
        this.subUser = subUser;
    }

    @Override
    public void close() throws IOException {
    }
}

