/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.renderinterface.parameters;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;

@JsonPropertyOrder(value={"mask", "visible", "filter"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class PrintAreaDefinitionLayerFilter {
    @JsonProperty(value="mask")
    private String layerMask;
    @JsonProperty(value="filter")
    private String filterExpression;
    @JsonProperty(value="visible")
    private Boolean visible;

    public PrintAreaDefinitionLayerFilter() {
        this.layerMask = null;
        this.filterExpression = null;
        this.visible = null;
    }

    public PrintAreaDefinitionLayerFilter(String layerMask, String filterExpression, Boolean visible) {
        this.layerMask = layerMask;
        this.filterExpression = filterExpression;
        this.visible = visible;
    }

    @JsonProperty(value="filter")
    public String getFilterExpression() {
        return this.filterExpression;
    }

    @JsonProperty(value="filter")
    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    @JsonProperty(value="mask")
    public String getLayerMask() {
        return this.layerMask;
    }

    @JsonProperty(value="mask")
    public void setLayerMask(String layerMask) {
        this.layerMask = layerMask;
    }

    @JsonProperty(value="visible")
    public Boolean getVisible() {
        return this.visible;
    }

    @JsonProperty(value="visible")
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Objects.hashCode(this.layerMask);
        hash = 53 * hash + Objects.hashCode(this.filterExpression);
        hash = 53 * hash + Objects.hashCode(this.visible);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrintAreaDefinitionLayerFilter other = (PrintAreaDefinitionLayerFilter)obj;
        return ObjectUtils.equals((Object)other.getVisible(), (Object)this.getVisible()) && ObjectUtils.equals((Object)other.getFilterExpression(), (Object)this.getFilterExpression()) && ObjectUtils.equals((Object)other.getLayerMask(), (Object)this.getLayerMask());
    }

    public boolean matchesLayerMask(String layerKey) {
        if (this.layerMask != null) {
            Pattern p = Pattern.compile(this.getLayerMask(), 258);
            Matcher m = p.matcher(StringUtils.trimToEmpty((String)layerKey));
            return m.matches();
        }
        return false;
    }
}

