/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.renderinterface.data;

import de.riwagis.renderinterface.RenderInterfaceUtils;
import de.riwagis.renderinterface.data.PrintDataTable;
import de.riwagis.renderinterface.parameters.PrintAreaDefinition;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.JsonSerializer;

public class PrintDataRow {
    private final Map<String, String[]> dataMap = new TreeMap<String, String[]>();
    private final Map<String, PrintDataTable> tableMap = new TreeMap<String, PrintDataTable>();
    private final Map<String, PrintAreaDefinition> tablePrintAreas = new TreeMap<String, PrintAreaDefinition>();
    private final JsonSerializer<PrintAreaDefinition> pavSerializer;

    public PrintDataRow() {
        this(new PrintAreaDefinition.PrintAreaDefinitionSerializer(false));
    }

    public PrintDataRow(JsonSerializer<PrintAreaDefinition> pavSerializer) {
        this.pavSerializer = pavSerializer;
    }

    public boolean hasField(String fieldName) {
        return this.dataMap.containsKey(fieldName) || this.tableMap.containsKey(fieldName);
    }

    public PrintDataTable addDataTable(String fieldName) {
        this.assertFieldNotTaken(fieldName);
        PrintDataTable subList = new PrintDataTable(this.pavSerializer);
        this.tableMap.put(fieldName, subList);
        return subList;
    }

    public void addDataEntry(String fieldName, String value, String description) {
        this.assertFieldNotTaken(fieldName);
        this.dataMap.put(fieldName, new String[]{value, description});
    }

    public void assertFieldNotTaken(String fieldName) {
        if (this.hasField(fieldName)) {
            throw new AssertionError((Object)String.format("field '%s' already used", fieldName));
        }
    }

    public String getDataValue(String fieldName) {
        return this.dataMap.get(fieldName)[0];
    }

    public final Map<String, Object> build() throws IOException {
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String[]> entry : this.dataMap.entrySet()) {
            res.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.tableMap.entrySet()) {
            res.put(entry.getKey(), ((PrintDataTable)entry.getValue()).build());
        }
        for (Map.Entry<String, Object> entry : this.tablePrintAreas.entrySet()) {
            String fieldKey = String.format("%s_%s", "json_imageinfo", entry.getKey());
            res.put(fieldKey, new String[]{RenderInterfaceUtils.convertToJson((PrintAreaDefinition)entry.getValue(), this.pavSerializer), "geom"});
        }
        res.put(PrintDataRow.class.getCanonicalName(), true);
        return res;
    }

    public PrintAreaDefinition addPrintAreaEntry(String geometryID, String geometryWKT) {
        if (this.tablePrintAreas.containsKey(geometryID)) {
            throw new AssertionError((Object)String.format("geometryID already used: '%s'", geometryID));
        }
        this.tablePrintAreas.put(geometryID, new PrintAreaDefinition(geometryWKT));
        return this.tablePrintAreas.get(geometryID);
    }

    public void clearPhotos(String photoCollectionId) {
        String tableID = PrintDataRow.buildTableID(photoCollectionId);
        if (this.tableMap.containsKey(tableID)) {
            this.tableMap.remove(tableID);
        }
    }

    public PrintDataRow addPhoto(String photoCollectionId, int moduleID, int dialogID, int fieldID, String filterID) {
        String tableID = PrintDataRow.buildTableID(photoCollectionId);
        if (!this.tableMap.containsKey(tableID)) {
            this.tableMap.put(tableID, new PrintDataTable(this.pavSerializer));
        }
        PrintDataRow photoRow = this.tableMap.get(tableID).addRow();
        photoRow.addDataEntry("moduleKey", Integer.toString(moduleID), "module key");
        photoRow.addDataEntry("dialogKey", Integer.toString(dialogID), "dialog key");
        photoRow.addDataEntry("fieldKey", Integer.toString(fieldID), "field key");
        photoRow.addDataEntry("filterID", filterID, "filter ID");
        photoRow.addDataEntry("localfilename", "", "local file name");
        return photoRow;
    }

    private static String buildTableID(String photoCollectionId) {
        String tableID = StringUtils.isBlank((CharSequence)photoCollectionId) ? "photo" : String.format("photo_%s", photoCollectionId);
        return tableID;
    }
}

