/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.gui.dialogs;

import de.riwagis.util.Support;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PwdEncrypter
extends JFrame {
    private static final Logger LOG = LoggerFactory.getLogger(PwdEncrypter.class);
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA-1";
    public static final String SHA256 = "SHA-256";
    public static final String SHA384 = "SHA-384";
    public static final String SHA512 = "SHA-512";
    public static final String DES = "DES - Computer";
    public static final String DES_BY_STRING = "DES";
    public static final String PBKDF2_SHA512 = "PBKDF2WithHmacSHA512";
    public static final String[] SUPPORTED_ENC_ALGS = new String[]{"DES", "DES - Computer", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512", "PBKDF2WithHmacSHA512"};
    private JButton btnDoClose;
    private JButton btnDoEncrypt;
    private JComboBox<String> cmbEnc;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField txtEncPwd;
    private JTextField txtPwd;

    public PwdEncrypter() {
        this(DES);
    }

    public PwdEncrypter(String encMethod) {
        this(encMethod, (String)null);
    }

    public PwdEncrypter(String encMethod, String filter) {
        this.initComponents();
        if (filter == null || filter.isBlank()) {
            this.cmbEnc.setModel(new DefaultComboBoxModel<String>(SUPPORTED_ENC_ALGS));
        } else {
            String[] arrFilter = (String[])Stream.of(filter.split(",")).filter(Arrays.asList(SUPPORTED_ENC_ALGS)::contains).toArray(String[]::new);
            if (arrFilter.length == 0) {
                this.cmbEnc.setModel(new DefaultComboBoxModel<String>(SUPPORTED_ENC_ALGS));
            } else {
                this.cmbEnc.setModel(new DefaultComboBoxModel<String>(arrFilter));
            }
            if (arrFilter.length == 1) {
                this.cmbEnc.setVisible(false);
            }
        }
        this.cmbEnc.setSelectedItem(encMethod);
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.txtPwd = new JTextField();
        this.cmbEnc = new JComboBox();
        this.btnDoEncrypt = new JButton();
        this.jLabel2 = new JLabel();
        this.txtEncPwd = new JTextField();
        this.btnDoClose = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("de/riwagis/util/gui/dialogs/i18n");
        this.setTitle(bundle.getString("PwdEncrypter.frame_title"));
        this.setMinimumSize(new Dimension(450, 105));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel3.setText(bundle.getString("PwdEncrypter.explanation"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText(bundle.getString("PwdEncrypter.input_password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.txtPwd.setPreferredSize(new Dimension(300, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 9);
        this.getContentPane().add((Component)this.txtPwd, gridBagConstraints);
        this.cmbEnc.setPreferredSize(new Dimension(180, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.getContentPane().add(this.cmbEnc, gridBagConstraints);
        this.btnDoEncrypt.setText(bundle.getString("PwdEncrypter.doEncrypt"));
        this.btnDoEncrypt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PwdEncrypter.this.btnDoEncrypt_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.getContentPane().add((Component)this.btnDoEncrypt, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText(bundle.getString("PwdEncrypter.encryptedPassword"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 9, 9, 3);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.txtEncPwd.setEditable(false);
        this.txtEncPwd.setPreferredSize(new Dimension(300, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 9, 9);
        this.getContentPane().add((Component)this.txtEncPwd, gridBagConstraints);
        this.btnDoClose.setText(bundle.getString("PwdEncrypter.doClose"));
        this.btnDoClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PwdEncrypter.this.btnDoCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.getContentPane().add((Component)this.btnDoClose, gridBagConstraints);
        this.pack();
    }

    private void btnDoEncrypt_onActionPerformed(ActionEvent evt) {
        try {
            String strAlg = this.cmbEnc.getSelectedItem().toString();
            if (!strAlg.startsWith(DES_BY_STRING)) {
                if (strAlg.equals(PBKDF2_SHA512)) {
                    this.txtEncPwd.setText(Support.encryptOneWay((String)Support.encryptOneWay((char[])this.txtPwd.getText().toCharArray(), (String)SHA1), (String)strAlg));
                } else {
                    this.txtEncPwd.setText(Support.encryptOneWay((char[])this.txtPwd.getText().toCharArray(), (String)strAlg));
                }
            } else if (strAlg.equals(DES)) {
                byte[] arrKey = Support.getKeyByMacAdress();
                byte[] encPwd = Support.encrypt((char[])this.txtPwd.getText().toCharArray(), (byte[])arrKey);
                this.txtEncPwd.setText(new String(new Base64().encode(encPwd)));
            } else {
                String strEncText = GUISupport.inputbox((Component)this, (String)"Bitte Schl\u00fcssel eingeben:");
                byte[] arrKey = Support.getKeyByString((String)strEncText);
                byte[] encPwd = Support.encrypt((char[])this.txtPwd.getText().toCharArray(), (byte[])arrKey);
                this.txtEncPwd.setText(new String(new Base64().encode(encPwd)));
            }
        }
        catch (SystemException e) {
            LOG.error(String.format("error while encrypting password: %s", e.getMessage()), (Throwable)e);
            GUISupport.msgbox((Component)this, (String)e.getMessage(), (String)"Error");
        }
    }

    private void btnDoCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        EventQueue.invokeLater(() -> this.dispose());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> new PwdEncrypter().setVisible(true));
    }
}

