/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.security.encryption;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class RSAKeyUtils {
    public static final String RSA = "RSA";

    public static final KeyPair generateNewRSAKey() throws GeneralSecurityException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance(RSA);
        gen.initialize(2048);
        KeyPair key = gen.generateKeyPair();
        return key;
    }

    public static final PrivateKey loadPrivateKey(byte[] encodedKey) throws GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(encodedKey);
        PrivateKey privateKey = keyFactory.generatePrivate(privKeySpec);
        return privateKey;
    }

    public static final PrivateKey loadPrivateKey(String resource) throws IOException, GeneralSecurityException {
        try (InputStream fis = RSAKeyUtils.class.getResourceAsStream(resource);){
            PrivateKey privateKey = RSAKeyUtils.loadPrivateKey(IOUtils.toByteArray((InputStream)fis));
            return privateKey;
        }
    }

    public static final PrivateKey loadPrivateKey(File keyFile) throws IOException, GeneralSecurityException {
        try (FileInputStream fis = new FileInputStream(keyFile);){
            PrivateKey privateKey = RSAKeyUtils.loadPrivateKey(IOUtils.toByteArray((InputStream)fis));
            return privateKey;
        }
    }

    public static final void savePrivateKey(File keyFile, PrivateKey privateKey) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(keyFile);){
            PKCS8EncodedKeySpec pkcsKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
            ((OutputStream)fos).write(pkcsKeySpec.getEncoded());
        }
    }

    public static final PublicKey loadPublicKey(byte[] key) throws GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        X509EncodedKeySpec pkSpec = new X509EncodedKeySpec(key);
        PublicKey publicKey = keyFactory.generatePublic(pkSpec);
        return publicKey;
    }

    public static final PublicKey loadPublicKey(File keyFile) throws IOException, GeneralSecurityException {
        try (FileInputStream fis = new FileInputStream(keyFile);){
            PublicKey publicKey = RSAKeyUtils.loadPublicKey(IOUtils.toByteArray((InputStream)fis));
            return publicKey;
        }
    }

    public static final PublicKey loadPublicKey(String resource) throws IOException, GeneralSecurityException {
        try (InputStream fis = RSAKeyUtils.class.getResourceAsStream(resource);){
            PublicKey publicKey = RSAKeyUtils.loadPublicKey(IOUtils.toByteArray((InputStream)fis));
            return publicKey;
        }
    }

    public static final void savePublicKey(File keyFile, PublicKey publicKey) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(keyFile);){
            X509EncodedKeySpec x509ks = new X509EncodedKeySpec(publicKey.getEncoded());
            ((OutputStream)fos).write(x509ks.getEncoded());
        }
    }

    @Deprecated
    public static final String toByteArray(Key key) {
        return RSAKeyUtils.asByteArrayString(key);
    }

    public static final String asByteArrayString(Key key) {
        ArrayList<String> resArray = new ArrayList<String>();
        for (byte currByte : key.getEncoded()) {
            resArray.add(String.format("(byte)0x%02x", currByte));
        }
        return StringUtils.join(resArray, (String)", ");
    }

    private RSAKeyUtils() {
    }
}

