/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.security.encryption;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreUtils {
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreUtils.class);

    public static void saveKeyStoreFile(File keystoreFile, KeyStore keystore, String password) throws GeneralSecurityException, IOException {
        LOG.debug("save keystore to ''{}''", (Object)keystoreFile);
        try (FileOutputStream fos = new FileOutputStream(keystoreFile);){
            keystore.store(fos, password.toCharArray());
        }
    }

    public static void loadKeyStoreResource(String resourceName, KeyStore keystore, String password) throws GeneralSecurityException, IOException {
        LOG.debug("load keystore from resource ''{}''", (Object)resourceName);
        try (InputStream fis = KeyStoreUtils.class.getResourceAsStream(resourceName);){
            keystore.load(fis, password.toCharArray());
        }
    }

    public static void loadKeyStoreFile(File keystoreFile, KeyStore keystore, String password) throws GeneralSecurityException, IOException {
        LOG.debug("load keystore from ''{}''", (Object)keystoreFile);
        try (FileInputStream fis = new FileInputStream(keystoreFile);){
            keystore.load(fis, password.toCharArray());
        }
    }

    public static KeyPair getKeyPair(KeyStore keystore, String alias) throws GeneralSecurityException {
        Certificate cert2 = keystore.getCertificate(alias);
        if (cert2 != null) {
            return new KeyPair(cert2.getPublicKey(), (PrivateKey)keystore.getKey(alias, new char[0]));
        }
        return null;
    }

    private KeyStoreUtils() {
    }
}

