/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.security.encryption;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class EnDecryption {
    public static final String DEFAULT_ALGORITHM = "RSA";
    public static final String DEFAULT_SIGNALGO = "SHA1withRSA";
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final int DEFAULT_BUFSIZE = 1024;
    private static final byte[] IVSPEC_DEFAULTRANDOMVALUES = new byte[]{84, -105, 117, 121, -99, 75, -16, -119, -91, -96, -106, -24, -62, 24, -33, -71};
    private static final IvParameterSpec IVSPEC = new IvParameterSpec(IVSPEC_DEFAULTRANDOMVALUES);
    private static final String DEFAULT_SYM_CIPHER = "AES/CBC/PKCS5Padding";
    private static final String DEFAULT_SYM_KEYGEN = "AES";

    public static byte[] encrypt(byte[] byteMsg, PublicKey publicKey) throws GeneralSecurityException, IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(output);){
                Cipher cipher = Cipher.getInstance(DEFAULT_ALGORITHM);
                cipher.init(1, publicKey);
                SecretKey sessionKey = EnDecryption.buildRandomSecretKey();
                byte[] encodedSessionKey = sessionKey.getEncoded();
                byte[] dsaKeyEnc = cipher.doFinal(encodedSessionKey);
                dos.writeInt(dsaKeyEnc.length);
                dos.write(dsaKeyEnc);
                EnDecryption.writeEncrypted((OutputStream)dos, byteMsg, sessionKey);
                dos.flush();
                byArray = output.toByteArray();
            }
            return byArray;
        }
    }

    public static void writeEncrypted(OutputStream destination, byte[] message, SecretKey symKey) throws IOException, GeneralSecurityException {
        Cipher symmetricCipher = Cipher.getInstance(DEFAULT_SYM_CIPHER);
        symmetricCipher.init(1, (Key)symKey, IVSPEC);
        EnDecryption.writeEncrypted(destination, message, symmetricCipher);
    }

    public static void writeEncrypted(OutputStream destination, byte[] message, Cipher cipher) throws IOException, GeneralSecurityException {
        try (ByteArrayInputStream bytesIS = new ByteArrayInputStream(message);
             BufferedInputStream bis = new BufferedInputStream(bytesIS);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)bis).read(buffer)) >= 0) {
                destination.write(cipher.update(buffer, 0, len));
            }
            destination.write(cipher.doFinal());
        }
    }

    public static byte[] readDecrypted(InputStream sourceStream, SecretKey symKey) throws GeneralSecurityException, IOException {
        Cipher symmetricCipher = Cipher.getInstance(DEFAULT_SYM_CIPHER);
        symmetricCipher.init(2, (Key)symKey, IVSPEC);
        return EnDecryption.readDecrypted(sourceStream, symmetricCipher);
    }

    public static byte[] readDecrypted(InputStream sourceStream, Cipher symmetricCipher) throws GeneralSecurityException, IOException {
        try (ByteArrayOutputStream decryptedMessage = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = sourceStream.read(buffer)) >= 0) {
                decryptedMessage.write(symmetricCipher.update(buffer, 0, len));
            }
            decryptedMessage.write(symmetricCipher.doFinal());
            decryptedMessage.flush();
            byte[] byArray = decryptedMessage.toByteArray();
            return byArray;
        }
    }

    public static SecretKey buildRandomSecretKey() throws GeneralSecurityException {
        KeyGenerator keyGen = KeyGenerator.getInstance(DEFAULT_SYM_KEYGEN);
        keyGen.init(128);
        return keyGen.generateKey();
    }

    public static byte[] encryptString(String text, PublicKey publicKey) throws GeneralSecurityException, IOException {
        return EnDecryption.encrypt(text.getBytes(DEFAULT_CHARSET), publicKey);
    }

    public static byte[] decrypt(byte[] encryptedMessage, PrivateKey key) throws GeneralSecurityException, IOException {
        try (ByteArrayInputStream bytesIS = new ByteArrayInputStream(encryptedMessage);){
            byte[] byArray;
            try (DataInputStream dis = new DataInputStream(bytesIS);){
                int symmetricKeyEncryptedLength = dis.readInt();
                byte[] symmetricKeyEncrypted = new byte[symmetricKeyEncryptedLength];
                dis.read(symmetricKeyEncrypted);
                Cipher cipher = Cipher.getInstance(DEFAULT_ALGORITHM);
                cipher.init(2, key);
                byte[] symmectricKey = cipher.doFinal(symmetricKeyEncrypted);
                SecretKeySpec symKey = new SecretKeySpec(symmectricKey, 0, symmectricKey.length, DEFAULT_SYM_KEYGEN);
                byArray = EnDecryption.readDecrypted((InputStream)dis, symKey);
            }
            return byArray;
        }
    }

    public static String decryptString(byte[] encryptedMessage, PrivateKey key) throws GeneralSecurityException, IOException {
        return new String(EnDecryption.decrypt(encryptedMessage, key), DEFAULT_CHARSET);
    }

    public static byte[] calculateSignature(PrivateKey privateKey, String message) throws GeneralSecurityException, IOException {
        return EnDecryption.calculateSignature(privateKey, message.getBytes(DEFAULT_CHARSET));
    }

    public static byte[] calculateSignature(PrivateKey privateKey, byte[] message) throws GeneralSecurityException, IOException {
        Signature dsa = Signature.getInstance(DEFAULT_SIGNALGO);
        dsa.initSign(privateKey);
        try (ByteArrayInputStream bytesIS = new ByteArrayInputStream(message);
             BufferedInputStream r = new BufferedInputStream(bytesIS);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)r).read(buffer)) >= 0) {
                dsa.update(buffer, 0, len);
            }
        }
        return dsa.sign();
    }

    public static boolean verifySignature(PublicKey publicKey, String message, byte[] signatureRead) throws GeneralSecurityException, IOException {
        return EnDecryption.verifySignature(publicKey, message.getBytes(DEFAULT_CHARSET), signatureRead);
    }

    public static boolean verifySignature(PublicKey publicKey, byte[] message, byte[] signatureRead) throws GeneralSecurityException, IOException {
        Signature sig = Signature.getInstance(DEFAULT_SIGNALGO);
        sig.initVerify(publicKey);
        try (ByteArrayInputStream bytesIS = new ByteArrayInputStream(message);
             BufferedInputStream bufin = new BufferedInputStream(bytesIS);){
            byte[] buffer = new byte[1024];
            while (((InputStream)bufin).available() != 0) {
                int len = ((InputStream)bufin).read(buffer);
                sig.update(buffer, 0, len);
            }
        }
        boolean verifies = sig.verify(signatureRead);
        return verifies;
    }

    public static final String decryptVerifyMessage(String encSignedMsgBase64enc, PrivateKey messagePrivateKey, PublicKey signaturePublicKey) throws IOException, GeneralSecurityException {
        byte[] decodedMessage = Base64.decodeBase64((String)encSignedMsgBase64enc);
        byte[] decryptedMessage = EnDecryption.decrypt(decodedMessage, messagePrivateKey);
        try (ByteArrayInputStream bytesIS = new ByteArrayInputStream(decryptedMessage);
             DataInputStream dis = new DataInputStream(bytesIS);){
            int signlength = dis.readInt();
            byte[] signatureRead = new byte[signlength];
            dis.read(signatureRead);
            String msgRead = dis.readUTF();
            if (EnDecryption.verifySignature(signaturePublicKey, msgRead, signatureRead)) {
                String string = msgRead;
                return string;
            }
        }
        return null;
    }

    public static final String signEncryptMessage(PrivateKey signaturePrivateKey, String plainText, PublicKey messagePublicKey) throws GeneralSecurityException, IOException {
        byte[] signedMsg;
        byte[] signature = EnDecryption.calculateSignature(signaturePrivateKey, plainText);
        try (ByteArrayOutputStream signedMsgOutputStream = new ByteArrayOutputStream();
             DataOutputStream out = new DataOutputStream(signedMsgOutputStream);){
            int signlength = signature.length;
            out.writeInt(signlength);
            out.write(signature, 0, signlength);
            out.writeUTF(plainText);
            signedMsgOutputStream.flush();
            signedMsg = signedMsgOutputStream.toByteArray();
        }
        byte[] encryptedSignedMsg = EnDecryption.encrypt(signedMsg, messagePublicKey);
        String encSignedMsgBase64enc = Base64.encodeBase64String((byte[])encryptedSignedMsg);
        return encSignedMsgBase64enc;
    }

    public static byte[] encryptSymmetric(byte[] plainMessage, SecretKey key) throws IOException, GeneralSecurityException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            EnDecryption.writeEncrypted((OutputStream)bos, plainMessage, key);
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static byte[] decryptSymmetric(byte[] encryptedMessage, SecretKey key) throws IOException, GeneralSecurityException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(encryptedMessage);){
            byte[] byArray = EnDecryption.readDecrypted((InputStream)bis, key);
            return byArray;
        }
    }

    private EnDecryption() {
    }
}

