/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.security.encryption;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class DESCryptUtils {
    public static final String CIPHER_DES = "DES";

    public static byte[] encrypt(char[] plainText, byte[] arrKey) throws GeneralSecurityException {
        SecretKey k = DESCryptUtils.buildDESKey(arrKey);
        Cipher c = Cipher.getInstance(CIPHER_DES);
        c.init(1, k);
        byte[] data = DESCryptUtils.toBytes(plainText);
        return c.doFinal(data);
    }

    public static byte[] encryptFromString(String plainText, byte[] arrKey) throws GeneralSecurityException {
        return DESCryptUtils.encrypt(plainText.toCharArray(), arrKey);
    }

    public static char[] decrypt(byte[] encryptedMessage, byte[] arrKey) throws GeneralSecurityException {
        SecretKey k = DESCryptUtils.buildDESKey(arrKey);
        Cipher c = Cipher.getInstance(k.getAlgorithm());
        c.init(2, k);
        byte[] decryptedData = c.doFinal(encryptedMessage);
        return DESCryptUtils.toChars(decryptedData);
    }

    public static SecretKey buildDESKey(byte[] arrKey) {
        return new SecretKeySpec(arrKey, CIPHER_DES);
    }

    public static byte[] toBytes(char[] chrData) {
        byte[] data = new byte[chrData.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = DESCryptUtils.toByte(chrData[i]);
        }
        return data;
    }

    public static char[] toChars(byte[] oriData) {
        char[] chrOriData = new char[oriData.length];
        for (int i = 0; i < oriData.length; ++i) {
            chrOriData[i] = DESCryptUtils.toChar(oriData[i]);
        }
        return chrOriData;
    }

    public static String decryptToString(byte[] data, byte[] arrKey) throws GeneralSecurityException {
        return new String(DESCryptUtils.decrypt(data, arrKey));
    }

    public static char toChar(byte bte) {
        return (char)(bte & 0xFF);
    }

    public static byte toByte(char chr) {
        return (byte)(chr & 0xFF);
    }
}

