/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.granulehandler;

import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.granulehandler.GranuleHandler;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.Envelope;

public class DefaultGranuleHandler
implements GranuleHandler {
    private static final PrecisionModel PRECISION_MODEL = new PrecisionModel(PrecisionModel.FLOATING);
    private static final GeometryFactory GEOM_FACTORY = new GeometryFactory(PRECISION_MODEL);

    @Override
    public void handleGranule(Object source, GridCoverage2DReader inputReader, SimpleFeature targetFeature, SimpleFeatureType targetFeatureType, SimpleFeature feature, SimpleFeatureType inputFeatureType, MosaicConfigurationBean mosaicConfiguration) {
        if (inputReader instanceof StructuredGridCoverage2DReader) {
            this.handleStructuredGranule(source, inputReader, targetFeature, targetFeatureType, feature, inputFeatureType, mosaicConfiguration);
        } else {
            GeneralEnvelope coverageEnvelope = inputReader.getOriginalEnvelope();
            targetFeature.setAttribute(targetFeatureType.getGeometryDescriptor().getLocalName(), (Object)GEOM_FACTORY.toGeometry((org.locationtech.jts.geom.Envelope)new ReferencedEnvelope((Envelope)coverageEnvelope)));
        }
    }
}

