/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.egr;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.datum.PixelInCell;

public final class RendererUtilities {
    private static final Logger LOGGER = Logging.getLogger(RendererUtilities.class);
    private static final ThreadLocal<GridToEnvelopeMapper> gridToEnvelopeMappers = new ThreadLocal<GridToEnvelopeMapper>(){

        @Override
        protected GridToEnvelopeMapper initialValue() {
            GridToEnvelopeMapper mapper = new GridToEnvelopeMapper();
            mapper.setPixelAnchor(PixelInCell.CELL_CORNER);
            return mapper;
        }
    };

    private RendererUtilities() {
    }

    public static AffineTransform worldToScreenTransform(ReferencedEnvelope mapExtent, Rectangle paintArea) {
        Envelope2D genvelope = new Envelope2D((Envelope)mapExtent);
        GridToEnvelopeMapper m = gridToEnvelopeMappers.get();
        try {
            m.setGridRange((GridEnvelope)new GridEnvelope2D(paintArea));
            m.setEnvelope((Envelope)genvelope);
            return m.createAffineTransform().createInverse();
        }
        catch (NoninvertibleTransformException | MismatchedDimensionException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static org.locationtech.jts.geom.Envelope createMapEnvelope(Rectangle paintArea, AffineTransform worldToScreen) throws NoninvertibleTransformException {
        double[] pts = new double[]{paintArea.getMinX(), paintArea.getMinY(), paintArea.getMaxX(), paintArea.getMinY(), paintArea.getMaxX(), paintArea.getMaxY(), paintArea.getMinX(), paintArea.getMaxY()};
        worldToScreen.inverseTransform(pts, 0, pts, 0, 4);
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        double yMax = -1.7976931348623157E308;
        for (int i = 0; i < 4; ++i) {
            xMin = Math.min(xMin, pts[2 * i]);
            yMin = Math.min(yMin, pts[2 * i + 1]);
            xMax = Math.max(xMax, pts[2 * i]);
            yMax = Math.max(yMax, pts[2 * i + 1]);
        }
        return new org.locationtech.jts.geom.Envelope(xMin, xMax, yMin, yMax);
    }
}

