/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.coverage.grid.io.footprint.FootprintLoader;
import org.geotools.coverage.grid.io.footprint.FootprintLoaderSpi;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.util.URLs;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class ShapefileLoaderSPI
implements FootprintLoaderSpi {
    public FootprintLoader createLoader() {
        return new ShapefileLoader();
    }

    public class ShapefileLoader
    implements FootprintLoader {
        /*
         * Loose catch block
         */
        public Geometry loadFootprint(String pathNoExtension) throws Exception {
            File file = new File(pathNoExtension + ".shp");
            if (file.exists()) {
                ShapefileDataStore ds = new ShapefileDataStore(URLs.fileToUrl((File)file));
                try {
                    Geometry geometry;
                    try (SimpleFeatureIterator fi = ds.getFeatureSource().getFeatures().features();){
                        if (!fi.hasNext()) {
                            Geometry geometry2 = null;
                            return geometry2;
                        }
                        SimpleFeature sf = (SimpleFeature)fi.next();
                        Geometry result = (Geometry)sf.getDefaultGeometry();
                        if (fi.hasNext()) {
                            throw new IOException("Found more than one footprint record in the shapefile " + file.getCanonicalPath());
                        }
                        geometry = result;
                    }
                    return geometry;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    ds.dispose();
                }
            }
            return null;
        }

        public List<File> getFootprintFiles(String pathNoExtension) {
            File file = new File(pathNoExtension + ".shp");
            if (file.exists()) {
                ArrayList<File> result = new ArrayList<File>();
                result.add(file);
                for (ShpFileType type : ShpFileType.values()) {
                    File sidecar = new File(pathNoExtension + "." + type.extension);
                    if (!sidecar.exists()) continue;
                    result.add(sidecar);
                }
                return result;
            }
            return Collections.emptyList();
        }
    }
}

