/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.sort.SortedFeatureReader;
import org.geotools.feature.SchemaException;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.AbstractGTDataStoreGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.geometry.BoundingBox;

class STRTreeGranuleCatalog
extends GranuleCatalog {
    static final Logger LOGGER = Logging.getLogger(STRTreeGranuleCatalog.class);
    private GranuleCatalog wrappedCatalogue;
    private String typeName;
    private STRtree index;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    public STRTreeGranuleCatalog(Properties params, AbstractGTDataStoreGranuleCatalog wrappedCatalogue, Hints hints) {
        super(hints);
        Utilities.ensureNonNull((String)"params", (Object)params);
        this.wrappedCatalogue = wrappedCatalogue;
        this.typeName = (String)params.get("TypeName");
        if (this.typeName == null) {
            wrappedCatalogue.getValidTypeNames().iterator().next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UL_UNRELEASED_LOCK"})
    private void checkIndex(Lock readLock) throws IOException {
        Lock writeLock = this.rwLock.writeLock();
        try {
            readLock.unlock();
            writeLock.lock();
            if (this.index == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("No index exits and we create a new one.");
                }
                this.createIndex();
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index does not need to be created...");
            }
        }
        finally {
            try {
                readLock.lock();
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    private void createIndex() {
        Iterator it = null;
        final ArrayList features = new ArrayList();
        try {
            this.wrappedCatalogue.getGranuleDescriptors(new Query(this.typeName), new GranuleCatalogVisitor(){

                @Override
                public void visit(GranuleDescriptor granule, SimpleFeature o) {
                    features.add(granule);
                }
            });
            if (features == null) {
                throw new NullPointerException("The provided SimpleFeatureCollection is null, it's impossible to create an index!");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index Loaded");
            }
            it = features.iterator();
            STRtree tree = new STRtree();
            long size = 0L;
            while (it.hasNext()) {
                GranuleDescriptor granule = (GranuleDescriptor)it.next();
                ReferencedEnvelope env = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)granule.getGranuleBBOX());
                Polygon g = FeatureUtilities.getPolygon((Rectangle2D)new Rectangle2D.Double(env.getMinX(), env.getMinY(), env.getWidth(), env.getHeight()), (int)0);
                tree.insert(g.getEnvelopeInternal(), (Object)granule);
            }
            tree.build();
            this.index = tree;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GranuleDescriptor> getGranules(BoundingBox envelope) throws IOException {
        Utilities.ensureNonNull((String)"envelope", (Object)envelope);
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            this.checkIndex(lock);
            List list = this.index.query((Envelope)ReferencedEnvelope.reference((org.opengis.geometry.Envelope)envelope));
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getGranules(BoundingBox envelope, GranuleCatalogVisitor visitor) throws IOException {
        Utilities.ensureNonNull((String)"envelope", (Object)envelope);
        Utilities.ensureNonNull((String)"visitor", (Object)visitor);
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            this.checkIndex(lock);
            this.index.query((Envelope)ReferencedEnvelope.reference((org.opengis.geometry.Envelope)envelope), (ItemVisitor)new JTSIndexVisitorAdapter(visitor));
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void dispose() {
        Lock l = this.rwLock.writeLock();
        try {
            block7: {
                l.lock();
                if (this.wrappedCatalogue != null) {
                    try {
                        this.wrappedCatalogue.dispose();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block7;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
            if (this.multiScaleROIProvider != null) {
                this.multiScaleROIProvider.dispose();
            }
        }
        finally {
            this.index = null;
            this.multiScaleROIProvider = null;
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleFeatureCollection getGranules(Query q) throws IOException {
        q = this.mergeHints(q);
        Utilities.ensureNonNull((String)"q", (Object)q);
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            Filter filter = q.getFilter();
            ReferencedEnvelope requestedBBox = this.extractAndCombineBBox(filter);
            this.checkIndex(lock);
            List features = this.index.query((Envelope)requestedBBox);
            List<Object> filtered = new ArrayList<SimpleFeature>();
            int maxGranules = q.getMaxFeatures();
            int numGranules = 0;
            for (GranuleDescriptor g : features) {
                if (q.getSortBy() == null && maxGranules > 0 && numGranules >= maxGranules) break;
                SimpleFeature originator = g.getOriginator();
                if (originator == null || !filter.evaluate((Object)originator)) continue;
                if (Boolean.TRUE.equals(q.getHints().get((Object)GranuleSource.NATIVE_BOUNDS))) {
                    originator.getUserData().put("nativeBounds", ReferencedEnvelope.reference((org.opengis.geometry.Envelope)g.getGranuleBBOX()));
                }
                filtered.add(originator);
            }
            if (q.getSortBy() != null) {
                Comparator<SimpleFeature> comparator = SortedFeatureReader.getComparator(q.getSortBy());
                if (comparator != null) {
                    Collections.sort(filtered, comparator);
                }
                if (maxGranules > 0 && filtered.size() > maxGranules) {
                    filtered = filtered.subList(0, maxGranules);
                }
            }
            ListFeatureCollection listFeatureCollection = new ListFeatureCollection(this.wrappedCatalogue.getType(this.typeName), filtered);
            return listFeatureCollection;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public SimpleFeatureCollection getGranules(Query q, Transaction t) throws IOException {
        return this.getGranules(q);
    }

    private ReferencedEnvelope extractAndCombineBBox(Filter filter) {
        Utils.BBOXFilterExtractor bboxExtractor = new Utils.BBOXFilterExtractor();
        filter.accept((FilterVisitor)bboxExtractor, null);
        BoundingBox bbox = this.wrappedCatalogue.getBounds(this.typeName);
        return ReferencedEnvelope.reference((org.opengis.geometry.Envelope)bbox);
    }

    public List<GranuleDescriptor> getGranules() throws IOException {
        return this.getGranules(this.getBounds(this.typeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getGranuleDescriptors(Query q, GranuleCatalogVisitor visitor) throws IOException {
        block7: {
            Utilities.ensureNonNull((String)"q", (Object)q);
            Lock lock = this.rwLock.readLock();
            try {
                Comparator<SimpleFeature> comparator;
                lock.lock();
                this.checkStore();
                Filter filter = q.getFilter();
                ReferencedEnvelope requestedBBox = this.extractAndCombineBBox(filter);
                this.checkIndex(lock);
                Comparator<SimpleFeature> comparator2 = comparator = q.getSortBy() == null ? null : SortedFeatureReader.getComparator(q.getSortBy());
                if (comparator == null) {
                    this.index.query((Envelope)requestedBBox, (ItemVisitor)new JTSIndexVisitorAdapter(visitor, q));
                    break block7;
                }
                List unfilteredGranules = this.index.query((Envelope)requestedBBox);
                List granules = unfilteredGranules.stream().filter(gd -> filter.evaluate((Object)gd.getOriginator())).collect(Collectors.toList());
                Comparator granuleComparator = (gd1, gd2) -> {
                    SimpleFeature sf1 = gd1.getOriginator();
                    SimpleFeature sf2 = gd2.getOriginator();
                    return comparator.compare(sf1, sf2);
                };
                Collections.sort(granules, granuleComparator);
                int maxGranules = q.getMaxFeatures();
                if (maxGranules > 0 && granules.size() > maxGranules) {
                    granules = granules.subList(0, maxGranules);
                }
                for (GranuleDescriptor gd3 : granules) {
                    if (visitor.isVisitComplete()) {
                        break;
                    }
                    visitor.visit(gd3, gd3.getOriginator());
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BoundingBox getBounds(String typeName) {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            BoundingBox boundingBox = this.wrappedCatalogue.getBounds(typeName);
            return boundingBox;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public BoundingBox getBounds(String typeName, Transaction t) {
        return this.getBounds(typeName);
    }

    private void checkStore() throws IllegalStateException {
        if (this.wrappedCatalogue == null) {
            throw new IllegalStateException("The underlying store has already been disposed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleFeatureType getType(String typeName) throws IOException {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureType simpleFeatureType = this.wrappedCatalogue.getType(typeName);
            return simpleFeatureType;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String[] getTypeNames() {
        String[] stringArray;
        if (this.typeName != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.typeName;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeAggregateFunction(Query query, FeatureCalc function) throws IOException {
        query = this.mergeHints(query);
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            this.wrappedCatalogue.computeAggregateFunction(query, function);
        }
        finally {
            lock.unlock();
        }
    }

    public QueryCapabilities getQueryCapabilities() {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            QueryCapabilities queryCapabilities = this.wrappedCatalogue.getQueryCapabilities(this.typeName);
            return queryCapabilities;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int getGranulesCount(Query q) throws IOException {
        return this.wrappedCatalogue.getGranulesCount(this.mergeHints(q));
    }

    @Override
    public void addGranule(String typeName, SimpleFeature granule, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void addGranules(String typeName, Collection<SimpleFeature> granules, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void createType(String namespace, String typeName, String typeSpec) throws IOException, SchemaException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void createType(SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void createType(String identification, String typeSpec) throws SchemaException, IOException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public QueryCapabilities getQueryCapabilities(String typeName) {
        if (this.typeName.equals(typeName)) {
            return this.getQueryCapabilities();
        }
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public int removeGranules(Query query) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void removeType(String typeName) throws IOException {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            this.wrappedCatalogue.removeType(typeName);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void drop() throws IOException {
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            this.wrappedCatalogue.drop();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            lock.unlock();
        }
    }

    private static class JTSIndexVisitorAdapter
    implements ItemVisitor {
        private GranuleCatalogVisitor adaptee;
        private Filter filter;
        private int maxGranules = -1;
        private int granuleIndex = 0;

        public JTSIndexVisitorAdapter(GranuleCatalogVisitor adaptee) {
            this(adaptee, (Query)null);
        }

        public JTSIndexVisitorAdapter(GranuleCatalogVisitor adaptee, Query q) {
            this.adaptee = adaptee;
            this.filter = q == null ? Query.ALL.getFilter() : q.getFilter();
            this.maxGranules = q == null ? -1 : q.getMaxFeatures();
        }

        public JTSIndexVisitorAdapter(GranuleCatalogVisitor adaptee, Filter filter) {
            this.adaptee = adaptee;
            this.filter = filter == null ? Query.ALL.getFilter() : filter;
        }

        public void visitItem(Object o) {
            if (this.maxGranules > 0 && this.granuleIndex > this.maxGranules) {
                return;
            }
            if (this.adaptee.isVisitComplete()) {
                return;
            }
            if (o instanceof GranuleDescriptor) {
                GranuleDescriptor g = (GranuleDescriptor)o;
                SimpleFeature originator = g.getOriginator();
                if (originator != null && this.filter.evaluate((Object)originator)) {
                    this.adaptee.visit(g, null);
                    ++this.granuleIndex;
                }
                return;
            }
            throw new IllegalArgumentException("Unable to visit provided item" + o);
        }
    }
}

