/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.catalog.FileViewCollection;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;
import org.opengis.feature.simple.SimpleFeatureType;

public class GranuleCatalogSource
implements GranuleSource {
    protected GranuleCatalog catalog;
    protected String typeName;
    protected Hints hints;
    protected RasterManager manager;

    public GranuleCatalogSource(RasterManager manager, GranuleCatalog catalog, String typeName, Hints hints) {
        this.catalog = catalog;
        this.typeName = typeName;
        this.hints = hints;
        this.manager = manager;
    }

    public SimpleFeatureCollection getGranules(Query q) throws IOException {
        Query updatedQuery = this.setupBaseQuery(q);
        if (Boolean.TRUE.equals(q.getHints().get((Object)GranuleSource.FILE_VIEW))) {
            return new FileViewCollection(this.catalog, updatedQuery, this.manager);
        }
        return this.catalog.getGranules(updatedQuery);
    }

    private Query setupBaseQuery(Query q) {
        Query baseQuery = new Query();
        baseQuery.setHints(this.hints);
        baseQuery.setTypeName(this.typeName);
        if (q == null) {
            return baseQuery;
        }
        if (q.getTypeName() != null && !Objects.equals(this.typeName, q.getTypeName())) {
            throw new IllegalArgumentException("Invalid type name in query " + q.getTypeName() + ", this granule source only returns " + this.typeName);
        }
        if (this.hints != null) {
            q.getHints().putAll((Map)this.hints);
        }
        return DataUtilities.mixQueries(baseQuery, q, null);
    }

    public int getCount(Query q) throws IOException {
        q = this.setupBaseQuery(q);
        return this.catalog.getGranulesCount(q);
    }

    public ReferencedEnvelope getBounds(Query q) throws IOException {
        return this.getGranules(q).getBounds();
    }

    public SimpleFeatureType getSchema() throws IOException {
        return this.catalog.getType(this.typeName);
    }

    public void dispose() throws IOException {
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        return Collections.singleton(GranuleSource.FILE_VIEW);
    }
}

