/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.acceptors;

import java.io.File;
import java.io.IOException;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.acceptors.GranuleAcceptor;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class HomogeneousCRSAcceptor
implements GranuleAcceptor {
    @Override
    public boolean accepts(GridCoverage2DReader reader, String inputCoverageName, File fileBeingProcessed, ImageMosaicConfigHandler mosaicConfigHandler) throws IOException {
        String targetCoverageName = mosaicConfigHandler.getTargetCoverageName(reader, inputCoverageName);
        MosaicConfigurationBean config = mosaicConfigHandler.getConfigurations().get(targetCoverageName);
        return config == null || this.checkCRS(reader, config, inputCoverageName);
    }

    private boolean checkCRS(GridCoverage2DReader reader, MosaicConfigurationBean config, String inputCoverageName) {
        CoordinateReferenceSystem expectedCRS = config.getCrs();
        if (expectedCRS == null) {
            expectedCRS = reader.getCoordinateReferenceSystem();
        }
        CoordinateReferenceSystem actualCRS = reader.getCoordinateReferenceSystem(inputCoverageName);
        return CRS.equalsIgnoreMetadata((Object)expectedCRS, (Object)actualCRS);
    }
}

