/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.Query;
import org.geotools.filter.SortByImpl;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

class MosaicQueryBuilder {
    static final Logger LOGGER = Logging.getLogger(MosaicQueryBuilder.class);
    RasterLayerRequest request;
    RasterManager rasterManager;
    ReferencedEnvelope queryBBox;

    public MosaicQueryBuilder(RasterLayerRequest request, ReferencedEnvelope bbox) {
        this.request = request;
        this.rasterManager = request.getRasterManager();
        this.queryBBox = bbox;
    }

    public Query build() throws TransformException, IOException, FactoryException {
        Query query = this.initQuery();
        this.handleAdditionalFilters(query);
        this.handleSortByClause(query);
        return query;
    }

    private Query initQuery() throws TransformException, FactoryException, IOException {
        String typeName = this.rasterManager.getTypeName();
        Object bbox = null;
        if (typeName != null) {
            List<ReferencedEnvelope> envelopes;
            ProjectionHandler handler;
            Query query = new Query(typeName);
            if (this.request.getMaximumNumberOfGranules() > 0) {
                query.setMaxFeatures(this.request.getMaximumNumberOfGranules());
            }
            PropertyName geometryProperty = FeatureUtilities.DEFAULT_FILTER_FACTORY.property(this.rasterManager.getGranuleCatalog().getType(typeName).getGeometryDescriptor().getName());
            if (this.request.isHeterogeneousGranules() && this.queryBBox != null && (handler = ProjectionHandlerFinder.getHandler(this.queryBBox, this.queryBBox.getCoordinateReferenceSystem(), true)) != null && (envelopes = handler.getQueryEnvelopes()) != null && !envelopes.isEmpty()) {
                ArrayList<BBOX> filters = new ArrayList<BBOX>();
                for (ReferencedEnvelope envelope : envelopes) {
                    BBOX f = FeatureUtilities.DEFAULT_FILTER_FACTORY.bbox((Expression)geometryProperty, (BoundingBox)envelope);
                    filters.add(f);
                }
                bbox = envelopes.size() == 1 ? (Filter)filters.get(0) : FeatureUtilities.DEFAULT_FILTER_FACTORY.or(filters);
            }
            if (bbox == null && this.queryBBox != null) {
                bbox = FeatureUtilities.DEFAULT_FILTER_FACTORY.bbox((Expression)geometryProperty, (BoundingBox)this.queryBBox);
            }
            if (bbox != null) {
                query.setFilter((Filter)bbox);
            }
            return query;
        }
        throw new IllegalStateException("GranuleCatalog feature type was null!!!");
    }

    private void handleAdditionalFilters(Query query) {
        boolean hasFilter;
        List<?> times = this.request.getRequestedTimes();
        List<?> elevations = this.request.getElevation();
        Map<String, List> additionalDomains = this.request.getRequestedAdditionalDomains();
        Filter filter = this.request.getFilter();
        boolean hasTime = times != null && !times.isEmpty();
        boolean hasElevation = elevations != null && !elevations.isEmpty();
        boolean hasAdditionalDomains = !additionalDomains.isEmpty();
        boolean bl = hasFilter = filter != null && !Filter.INCLUDE.equals(filter);
        if (hasElevation) {
            Filter elevationF = this.rasterManager.elevationDomainManager.createFilter("ELEVATION_DOMAIN", elevations);
            query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(query.getFilter(), elevationF));
        }
        if (hasFilter) {
            query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(query.getFilter(), filter));
        }
        if (hasTime) {
            Filter timeFilter = this.rasterManager.timeDomainManager.createFilter("TIME_DOMAIN", times);
            query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(query.getFilter(), timeFilter));
        }
        if (hasAdditionalDomains) {
            ArrayList<Filter> additionalFilter = new ArrayList<Filter>();
            for (Map.Entry<String, List> entry : additionalDomains.entrySet()) {
                String domainName = entry.getKey() + "_DOMAIN";
                additionalFilter.add(this.rasterManager.domainsManager.createFilter(domainName, entry.getValue()));
            }
            query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(query.getFilter(), (Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(additionalFilter)));
        }
    }

    private void handleSortByClause(Query query) throws IOException {
        Utilities.ensureNonNull((String)"query", (Object)query);
        LOGGER.fine("Prepping to manage SortBy Clause");
        String sortByClause = this.request.getSortClause();
        GranuleCatalog catalog = this.rasterManager.getGranuleCatalog();
        if (sortByClause != null && sortByClause.length() > 0) {
            String[] elements = sortByClause.split(",");
            if (elements != null && elements.length > 0) {
                ArrayList<SortByImpl> clauses = new ArrayList<SortByImpl>(elements.length);
                for (String element : elements) {
                    if (element == null || element.length() <= 0) continue;
                    try {
                        String attribute;
                        element = element.trim();
                        if (element.endsWith(" A")) {
                            attribute = element.substring(0, element.length() - 2);
                            clauses.add(new SortByImpl(FeatureUtilities.DEFAULT_FILTER_FACTORY.property(attribute), SortOrder.ASCENDING));
                            LOGGER.fine("Added clause ASCENDING on attribute:" + attribute);
                            continue;
                        }
                        if (element.contains(" D")) {
                            attribute = element.substring(0, element.length() - 2);
                            clauses.add(new SortByImpl(FeatureUtilities.DEFAULT_FILTER_FACTORY.property(attribute), SortOrder.DESCENDING));
                            LOGGER.fine("Added clause DESCENDING on attribute:" + attribute);
                            continue;
                        }
                        LOGGER.fine("Ignoring sort clause :" + element);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.INFO)) continue;
                        LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
                    }
                }
                SortBy[] sortBy = clauses.toArray(new SortBy[0]);
                if (catalog.getQueryCapabilities(this.rasterManager.getTypeName()).supportsSorting(sortBy)) {
                    query.setSortBy(sortBy);
                }
            } else {
                LOGGER.fine("No SortBy Clause");
            }
        } else {
            String crsAttribute = this.rasterManager.getCrsAttribute();
            if (crsAttribute != null) {
                SortByImpl sort = new SortByImpl(FeatureUtilities.DEFAULT_FILTER_FACTORY.property(crsAttribute), SortOrder.ASCENDING);
                Object[] sortBy = new SortBy[]{sort};
                if (catalog.getQueryCapabilities(this.rasterManager.getTypeName()).supportsSorting((SortBy[])sortBy)) {
                    query.setSortBy((SortBy[])sortBy);
                } else {
                    LOGGER.severe("Sorting parameter ignored, underlying datastore cannot sort on " + Arrays.toString(sortBy));
                }
            }
        }
    }
}

