/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;

abstract class ImageMosaicSourceElement<T> {
    ImageMosaicSourceElement() {
    }

    abstract T getInnerObject();

    abstract String getLocation(CatalogBuilderConfiguration var1) throws IOException;

    abstract void addToCollector(PropertiesCollector var1);

    abstract void fireHarvestingEvent(ImageMosaicEventHandlers var1, int var2, int var3, String var4);

    static class URLElement
    extends ImageMosaicSourceElement<URL> {
        URL url;

        public URLElement(URL url) {
            this.url = url;
        }

        @Override
        URL getInnerObject() {
            return this.url;
        }

        @Override
        String getLocation(CatalogBuilderConfiguration config) throws IOException {
            return this.url.toString();
        }

        @Override
        void addToCollector(PropertiesCollector pc) {
            pc.collect(this.getInnerObject());
        }

        @Override
        void fireHarvestingEvent(ImageMosaicEventHandlers eventHandler, int elementIndex, int numElements, String message) {
            eventHandler.fireUrlEvent(Level.FINE, this.url, true, message, (double)(elementIndex + 1) * 99.0 / (double)numElements);
        }
    }

    static class FileElement
    extends ImageMosaicSourceElement<File> {
        File file;

        FileElement(File file) {
            this.file = file;
        }

        @Override
        File getInnerObject() {
            return this.file;
        }

        @Override
        String getLocation(CatalogBuilderConfiguration config) throws IOException {
            return FileElement.prepareLocation(config, this.file);
        }

        @Override
        void addToCollector(PropertiesCollector pc) {
            pc.collect(this.getInnerObject());
        }

        @Override
        void fireHarvestingEvent(ImageMosaicEventHandlers eventHandler, int elementIndex, int numElements, String message) {
            eventHandler.fireFileEvent(Level.FINE, this.file, true, message, (double)(elementIndex + 1) * 99.0 / (double)numElements);
        }

        private static String prepareLocation(CatalogBuilderConfiguration runConfiguration, File fileBeingProcessed) throws IOException {
            String pathType = runConfiguration.getParameter("PathType");
            String absolutePath = runConfiguration.getParameter("AbsolutePath");
            if (Boolean.valueOf(absolutePath).booleanValue() || PathType.ABSOLUTE.name().equals(pathType)) {
                return fileBeingProcessed.getAbsolutePath();
            }
            String targetPath = fileBeingProcessed.getCanonicalPath();
            String basePath = runConfiguration.getParameter("RootMosaicDirectory");
            String relative = FileElement.getRelativePath(targetPath, basePath, File.separator);
            return relative;
        }

        private static String getRelativePath(String targetPath, String basePath, String pathSeparator) {
            int commonIndex;
            String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator((String)targetPath);
            String normalizedBasePath = FilenameUtils.normalizeNoEndSeparator((String)basePath);
            if (pathSeparator.equals("/")) {
                normalizedTargetPath = FilenameUtils.separatorsToUnix((String)normalizedTargetPath);
                normalizedBasePath = FilenameUtils.separatorsToUnix((String)normalizedBasePath);
            } else if (pathSeparator.equals("\\")) {
                normalizedTargetPath = FilenameUtils.separatorsToWindows((String)normalizedTargetPath);
                normalizedBasePath = FilenameUtils.separatorsToWindows((String)normalizedBasePath);
            } else {
                throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
            }
            String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
            String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
            StringBuilder common = new StringBuilder();
            for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
                common.append(target[commonIndex] + pathSeparator);
            }
            if (commonIndex == 0) {
                throw new RuntimeException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
            }
            boolean baseIsFile = true;
            File baseResource = new File(normalizedBasePath);
            if (baseResource.exists()) {
                baseIsFile = baseResource.isFile();
            } else if (basePath.endsWith(pathSeparator)) {
                baseIsFile = false;
            }
            StringBuilder relative = new StringBuilder();
            if (base.length != commonIndex) {
                int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
                for (int i = 0; i < numDirsUp; ++i) {
                    relative.append(".." + pathSeparator);
                }
            }
            relative.append(normalizedTargetPath.substring(common.length()));
            return relative.toString();
        }
    }
}

