/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.maskband.DatasetLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.ImageLayout;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.DefaultHarvestedSource;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GranuleStore;
import org.geotools.coverage.grid.io.HarvestedSource;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIProvider;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultFileServiceInfo;
import org.geotools.data.FileGroupProvider;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.gce.imagemosaic.CogGranuleAccessProvider;
import org.geotools.gce.imagemosaic.DefaultGranuleAccessProvider;
import org.geotools.gce.imagemosaic.GranuleAccessProvider;
import org.geotools.gce.imagemosaic.HarvestedResource;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicDescriptor;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicFileFeatureConsumer;
import org.geotools.gce.imagemosaic.ImageMosaicFileResourceInfo;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicURLFeatureConsumer;
import org.geotools.gce.imagemosaic.ImageMosaicWalker;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.OverviewsController;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.PurgingGranuleStore;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.URLSourceSPIProvider;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogFactory;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROIProviderMosaicFactory;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.URLs;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class ImageMosaicReader
extends AbstractGridCoverage2DReader
implements StructuredGridCoverage2DReader {
    Set<String> names = new HashSet<String>();
    String defaultName = null;
    public static final String UNSPECIFIED = "_UN$PECIFIED_";
    Map<String, RasterManager> rasterManagers = new ConcurrentHashMap<String, RasterManager>();
    private static final Logger LOGGER = Logging.getLogger(ImageMosaicReader.class);
    URL sourceURL;
    File parentDirectory;
    boolean expandMe;
    PathType pathType;
    ExecutorService multiThreadedLoader;
    String locationAttributeName = "location";
    int maxAllowedTiles = (Integer)ImageMosaicFormat.MAX_ALLOWED_TILES.getDefaultValue();
    ImageReaderSpi suggestedSPI;
    GranuleCatalog granuleCatalog;
    boolean cachingIndex;
    boolean imposedBBox;
    boolean heterogeneousGranules;
    boolean checkAuxiliaryMetadata = false;
    String typeName;

    public RasterManager getRasterManager(String name) {
        if (name != null && this.rasterManagers.containsKey(name)) {
            return this.rasterManagers.get(name);
        }
        return null;
    }

    public String[] getGridCoverageNames() {
        return this.names.toArray(new String[0]);
    }

    public ImageMosaicReader(Object source, Hints uHints) throws IOException {
        super(source, uHints);
        Object executor;
        if (this.hints.containsKey((Object)Hints.EXECUTOR_SERVICE) && (executor = uHints.get((Object)Hints.EXECUTOR_SERVICE)) != null && executor instanceof ExecutorService) {
            this.multiThreadedLoader = (ExecutorService)executor;
            if (LOGGER.isLoggable(Level.FINE) && this.multiThreadedLoader instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.multiThreadedLoader;
                LOGGER.fine("Using ThreadPoolExecutor with the following settings: core pool size = " + tpe.getCorePoolSize() + "\nmax pool size = " + tpe.getMaximumPoolSize() + "\nkeep alive time " + tpe.getKeepAliveTime(TimeUnit.MILLISECONDS));
            }
        }
        if (this.hints.containsKey((Object)Hints.MAX_ALLOWED_TILES)) {
            this.maxAllowedTiles = (Integer)this.hints.get((Object)Hints.MAX_ALLOWED_TILES);
        }
        if (source instanceof ImageMosaicDescriptor) {
            this.initReaderFromDescriptor((ImageMosaicDescriptor)source, uHints);
        } else {
            try {
                Hints localHints = new Hints((RenderingHints)uHints);
                if (localHints != null) {
                    localHints.add((RenderingHints)new Hints((RenderingHints.Key)Utils.MOSAIC_READER, (Object)this));
                }
                this.initReaderFromURL(source, localHints);
            }
            catch (Exception e) {
                throw new DataSourceException(e);
            }
        }
    }

    private void initReaderFromDescriptor(ImageMosaicDescriptor source, Hints uHints) throws IOException {
        Utilities.ensureNonNull((String)"source", (Object)source);
        MosaicConfigurationBean configuration = source.getConfiguration();
        if (configuration == null) {
            throw new DataSourceException("Unable to create reader for this mosaic since we could not parse the configuration.");
        }
        this.extractProperties(configuration);
        GranuleCatalog catalog = source.getCatalog();
        if (catalog == null) {
            throw new DataSourceException("Unable to create reader for this mosaic since the inner catalog is null.");
        }
        SimpleFeatureType schema = catalog.getType(configuration.getCatalogConfigurationBean().getTypeName());
        if (schema == null) {
            throw new DataSourceException("Unable to create reader for this mosaic since the inner catalog schema is null.");
        }
        this.granuleCatalog = catalog;
        this.setGridGeometry(this.typeName);
        this.addRasterManager(configuration, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReaderFromURL(Object source, Hints hints) throws Exception {
        this.sourceURL = Utils.checkSource(source, hints);
        if (this.sourceURL == null) {
            throw new DataSourceException("This plugin accepts File, URL or String. The string may describe a File or an URL");
        }
        MosaicConfigurationBean configuration = null;
        try {
            File sourceFile;
            if (this.sourceURL.getProtocol().equals("file") && !(sourceFile = URLs.urlToFile((URL)this.sourceURL)).exists()) {
                throw new DataSourceException("The specified sourceURL doesn't refer to an existing file");
            }
            File sourceParent = null;
            if (this.sourceURL != null) {
                sourceParent = this.parentDirectory = URLs.urlToFile((URL)this.sourceURL);
                if (!this.parentDirectory.isDirectory()) {
                    this.parentDirectory = this.parentDirectory.getParentFile();
                }
            }
            File datastoreProperties = new File(this.parentDirectory, "datastore.properties");
            configuration = Utils.loadMosaicProperties(this.sourceURL);
            if (configuration != null) {
                this.granuleCatalog = ImageMosaicConfigHandler.createCatalog(this.sourceURL, configuration, this.getCatalogHints(configuration.getCatalogConfigurationBean()));
                File parent = URLs.urlToFile((URL)this.sourceURL).getParentFile();
                MultiLevelROIProvider rois = MultiLevelROIProviderMosaicFactory.createFootprintProvider(parent);
                this.granuleCatalog.setMultiScaleROIProvider(rois);
                this.addRasterManager(configuration, true);
            } else {
                File[] properties;
                ArrayList<MosaicConfigurationBean> beans = new ArrayList<MosaicConfigurationBean>();
                if (configuration == null && sourceParent != null && this.parentDirectory != sourceParent) {
                    File sourceFile2 = URLs.urlToFile((URL)this.sourceURL);
                    File[] sourceFilePath = sourceFile2.getAbsolutePath();
                    if (!FilenameUtils.getName((String)sourceFilePath).equalsIgnoreCase("datastore.properties")) {
                        throw new DataSourceException("Files is neither a mosaic property nor a directory: " + this.sourceURL);
                    }
                    configuration = Utils.lookForMosaicConfig(this.sourceURL);
                    if (configuration != null) {
                        beans.add(configuration);
                    }
                }
                if (configuration == null && (properties = this.parentDirectory.listFiles((FilenameFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"indexer.properties")), FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"datastore.properties")), FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".properties"))})}))) != null) {
                    for (File propFile : properties) {
                        if (!Utils.checkFileReadable(propFile) || Utils.loadMosaicProperties(URLs.fileToUrl((File)propFile)) == null || (configuration = Utils.loadMosaicProperties(URLs.fileToUrl((File)propFile))) == null) continue;
                        beans.add(configuration);
                    }
                }
                if (beans.isEmpty() && !datastoreProperties.exists()) {
                    throw new DataSourceException("No mosaic properties file or datastore properties file have been found");
                }
                GranuleCatalog catalog = null;
                Properties params = ImageMosaicConfigHandler.createGranuleCatalogProperties(datastoreProperties);
                Object typeNames = params.get("TypeNames");
                if (typeNames != null) {
                    params.put("TypeNames", Boolean.valueOf(typeNames.toString()));
                } else {
                    params.put("TypeNames", Boolean.TRUE);
                }
                if (beans.isEmpty()) {
                    catalog = ImageMosaicConfigHandler.createGranuleCatalogFromDatastore(this.parentDirectory, datastoreProperties, true, this.getHints());
                } else {
                    MosaicConfigurationBean mosaicBean = beans.stream().filter(p -> p.getCatalogConfigurationBean().isHeterogeneous()).findFirst().orElse((MosaicConfigurationBean)beans.get(0));
                    CatalogConfigurationBean bean = mosaicBean.getCatalogConfigurationBean();
                    catalog = GranuleCatalogFactory.createGranuleCatalog(this.sourceURL, bean, params, this.getCatalogHints(bean));
                }
                MultiLevelROIProvider rois = MultiLevelROIProviderMosaicFactory.createFootprintProvider(this.parentDirectory);
                catalog.setMultiScaleROIProvider(rois);
                if (this.granuleCatalog != null) {
                    this.granuleCatalog.dispose();
                }
                this.granuleCatalog = catalog;
                for (MosaicConfigurationBean bean : beans) {
                    this.addRasterManager(bean, true);
                }
            }
        }
        catch (Throwable e) {
            try {
                if (this.granuleCatalog != null) {
                    this.granuleCatalog.dispose();
                }
            }
            catch (Throwable e1) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, e1.getLocalizedMessage(), e1);
                }
            }
            finally {
                this.granuleCatalog = null;
            }
            try {
                this.disposeManagers();
            }
            catch (Throwable e1) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, e1.getLocalizedMessage(), e1);
                }
            }
            finally {
                this.rasterManagers = null;
            }
            throw new DataSourceException(e);
        }
    }

    private Hints getCatalogHints(CatalogConfigurationBean bean) {
        Hints catalogHints = this.getHints();
        if (bean != null && bean.getUrlSourceSPIProvider() != null) {
            catalogHints = new Hints((RenderingHints)catalogHints);
            CogGranuleAccessProvider provider = new CogGranuleAccessProvider(bean);
            catalogHints.put((Object)GranuleAccessProvider.GRANULE_ACCESS_PROVIDER, (Object)provider);
        }
        return catalogHints;
    }

    private void setGridGeometry(ReferencedEnvelope envelope, GranuleCatalog catalog, String typeName) {
        Utilities.ensureNonNull((String)"index", (Object)catalog);
        BoundingBox bounds = catalog.getBounds(typeName);
        this.crs = bounds.getCoordinateReferenceSystem();
        if (envelope == null) {
            this.originalEnvelope = new GeneralEnvelope((Envelope)bounds);
        } else {
            this.originalEnvelope = new GeneralEnvelope((Envelope)envelope);
            this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
        }
        this.originalGridRange = new GridEnvelope2D(new Rectangle((int)(this.originalEnvelope.getSpan(0) / this.highestRes[0]), (int)(this.originalEnvelope.getSpan(1) / this.highestRes[1])));
        this.raster2Model = new AffineTransform2D(this.highestRes[0], 0.0, 0.0, -this.highestRes[1], this.originalEnvelope.getLowerCorner().getOrdinate(0) + 0.5 * this.highestRes[0], this.originalEnvelope.getUpperCorner().getOrdinate(1) - 0.5 * this.highestRes[1]);
    }

    private void setGridGeometry(String typeName) {
        this.setGridGeometry(null, this.granuleCatalog, typeName);
    }

    private void extractProperties(MosaicConfigurationBean configuration) throws IOException {
        this.numOverviews = configuration.getLevelsNum() - 1;
        double[][] resolutions = configuration.getLevels();
        this.overViewResolutions = this.numOverviews >= 1 ? new double[this.numOverviews][2] : (double[][])null;
        this.highestRes = new double[2];
        this.highestRes[0] = resolutions[0][0];
        this.highestRes[1] = resolutions[0][1];
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Highest res " + this.highestRes[0] + " " + this.highestRes[1]);
        }
        if (this.numOverviews > 0) {
            for (int i = 0; i < this.numOverviews; ++i) {
                this.overViewResolutions[i][0] = resolutions[i + 1][0];
                this.overViewResolutions[i][1] = resolutions[i + 1][1];
            }
        }
        this.coverageName = configuration.getName();
        this.expandMe = configuration.isExpandToRGB();
        this.checkAuxiliaryMetadata = configuration.isCheckAuxiliaryMetadata();
        CatalogConfigurationBean catalogConfigurationBean = configuration.getCatalogConfigurationBean();
        this.heterogeneousGranules = catalogConfigurationBean.isHeterogeneous();
        this.pathType = configuration.getCatalogConfigurationBean().getPathType();
        this.locationAttributeName = catalogConfigurationBean.getLocationAttribute();
        String suggestedSPIClass = catalogConfigurationBean.getSuggestedSPI();
        this.suggestedSPI = DefaultGranuleAccessProvider.createImageReaderSpiInstance(suggestedSPIClass);
        this.cachingIndex = catalogConfigurationBean.isCaching();
        this.imposedBBox = configuration.getEnvelope() != null;
        this.typeName = catalogConfigurationBean.getTypeName();
    }

    public ImageMosaicReader(Object source) throws IOException {
        this(source, null);
    }

    public Format getFormat() {
        return new ImageMosaicFormat();
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        return this.read(UNSPECIFIED, params);
    }

    public GridCoverage2D read(String coverageName, GeneralParameterValue[] params) throws IOException {
        Collection<GridCoverage2D> response;
        if (this.rasterManagers == null) {
            throw new IOException("Looks like this reader has been already disposed or it has not been properly initialized.");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            if (this.sourceURL != null) {
                LOGGER.fine("Reading mosaic from " + this.sourceURL.toString());
            } else {
                LOGGER.fine("Reading mosaic");
            }
            double[][] levels = this.getResolutionLevels(coverageName);
            if (levels != null) {
                double[] dArray = levels[0];
                LOGGER.fine("Highest res " + dArray[0] + " " + dArray[1]);
            }
        }
        if (this.maxAllowedTiles != (Integer)ImageMosaicFormat.MAX_ALLOWED_TILES.getDefaultValue()) {
            if (params != null) {
                boolean found = false;
                for (GeneralParameterValue pv : params) {
                    if (!pv.getDescriptor().getName().equals(ImageMosaicFormat.MAX_ALLOWED_TILES.getName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    GeneralParameterValue[] generalParameterValueArray = new GeneralParameterValue[params.length + 1];
                    System.arraycopy(params, 0, generalParameterValueArray, 0, params.length);
                    ParameterValue tempVal = ImageMosaicFormat.MAX_ALLOWED_TILES.createValue();
                    tempVal.setValue(this.maxAllowedTiles);
                    generalParameterValueArray[params.length] = tempVal;
                }
            } else {
                ParameterValue tempVal = ImageMosaicFormat.MAX_ALLOWED_TILES.createValue();
                tempVal.setValue(this.maxAllowedTiles);
                params = new GeneralParameterValue[]{tempVal};
            }
        }
        if ((response = this.read(params, coverageName)).isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("The response is empty. ==> returning a null GridCoverage");
            }
            return null;
        }
        GridCoverage2D gridCoverage2D = response.iterator().next();
        return gridCoverage2D;
    }

    private Collection<GridCoverage2D> read(GeneralParameterValue[] params, String coverageName) throws IOException {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        return this.getRasterManager(coverageName).read(params);
    }

    Hints getHints() {
        return this.hints;
    }

    double[] getHighestRes() {
        return this.highestRes;
    }

    double[][] getOverviewsResolution() {
        return this.overViewResolutions;
    }

    int getNumberOfOvervies() {
        return this.numOverviews;
    }

    MathTransform getRaster2Model() {
        return this.raster2Model;
    }

    GridCoverageFactory getGridCoverageFactory() {
        return this.coverageFactory;
    }

    public int getGridCoverageCount() {
        return this.names.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        super.dispose();
        ImageMosaicReader imageMosaicReader = this;
        synchronized (imageMosaicReader) {
            block6: {
                try {
                    if (this.granuleCatalog != null) {
                        this.granuleCatalog.dispose();
                    }
                    this.disposeManagers();
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block6;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    private void disposeManagers() {
        if (this.rasterManagers != null) {
            Set<String> keys = this.rasterManagers.keySet();
            for (String key : keys) {
                this.rasterManagers.get(key).dispose();
            }
            this.rasterManagers.clear();
            this.rasterManagers = null;
        }
    }

    public String[] getMetadataNames() {
        return this.getMetadataNames(UNSPECIFIED);
    }

    public String[] getMetadataNames(String coverageName) {
        String name = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(name);
        return manager != null ? manager.getMetadataNames() : null;
    }

    public String getMetadataValue(String name) {
        return this.getMetadataValue(UNSPECIFIED, name);
    }

    public String getMetadataValue(String coverageName, String name) {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(coverageName);
        return manager.getMetadataValue(name);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters() {
        return this.getDynamicParameters(UNSPECIFIED);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters(String coverageName) {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(coverageName);
        Set<ParameterDescriptor<List>> params = manager.domainsManager != null ? manager.domainsManager.getDynamicParameters() : Collections.emptySet();
        return params;
    }

    public boolean isParameterSupported(Identifier name) {
        return this.isParameterSupported(UNSPECIFIED, name);
    }

    public double[] getReadingResolutions(OverviewPolicy policy, double[] requestedResolution) throws IOException {
        return this.getReadingResolutions(UNSPECIFIED, policy, requestedResolution);
    }

    public double[] getReadingResolutions(String coverageName, OverviewPolicy policy, double[] requestedResolution) throws IOException {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(coverageName);
        DatasetLayout datasetLayout = this.getDatasetLayout(coverageName);
        int numOverviews = datasetLayout.getNumInternalOverviews() + datasetLayout.getNumExternalOverviews();
        OverviewsController overviewsController = manager.overviewsController;
        OverviewsController.OverviewLevel level = null;
        if (numOverviews > 0) {
            int imageIdx = overviewsController.pickOverviewLevel(policy, requestedResolution, null);
            level = overviewsController.getLevel(imageIdx);
        } else {
            level = overviewsController.getLevel(0);
        }
        return new double[]{level.resolutionX, level.resolutionY};
    }

    public boolean isParameterSupported(String coverageName, Identifier parameterName) {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(coverageName);
        return manager.domainsManager != null ? manager.domainsManager.isParameterSupported(parameterName) : false;
    }

    private String checkUnspecifiedCoverage(String coverageName) {
        if (coverageName.equalsIgnoreCase(UNSPECIFIED)) {
            if (this.getGridCoverageCount() > 1) {
                throw new IllegalArgumentException("Need to specify the coverageName for a reader related to multiple coverages");
            }
            return this.defaultName;
        }
        if (!this.names.contains(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName is unavailable");
        }
        return coverageName;
    }

    protected boolean checkName(String coverageName) {
        if (coverageName.equalsIgnoreCase(UNSPECIFIED)) {
            return this.getGridCoverageCount() == 1;
        }
        return this.names.contains(coverageName);
    }

    protected RasterManager addRasterManager(MosaicConfigurationBean configuration, boolean init) throws IOException {
        Utilities.ensureNonNull((String)"MosaicConfigurationBean", (Object)configuration);
        String name = configuration.getName();
        RasterManager rasterManager = new RasterManager(this, configuration);
        this.rasterManagers.put(name, rasterManager);
        this.names.add(name);
        if (this.defaultName == null) {
            this.defaultName = name;
        }
        if (init) {
            rasterManager.initialize(false);
        }
        return rasterManager;
    }

    public GranuleSource getGranules(String coverageName, boolean readOnly) throws IOException, UnsupportedOperationException {
        if (coverageName == null) {
            coverageName = this.defaultName;
        }
        RasterManager manager = this.getRasterManager(coverageName);
        Object source = null;
        if (manager != null && (source = manager.getGranuleSource(readOnly, this.getHints())) instanceof GranuleStore) {
            source = new PurgingGranuleStore((GranuleStore)source, manager);
        }
        return source;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void createCoverage(String coverageName, SimpleFeatureType indexSchema) throws IOException, UnsupportedOperationException {
        RasterManager manager = this.getRasterManager(coverageName);
        if (manager == null) {
            throw new IOException("This implementation requires to create a RasterManager for a coverage before creating the store. " + coverageName);
        }
        manager.createStore(indexSchema);
    }

    public boolean removeCoverage(String coverageName, boolean delete) throws IOException {
        return this.removeCoverage(coverageName, delete, true);
    }

    private boolean removeCoverage(String coverageName, boolean forceDelete, boolean checkForReferences) throws IOException {
        RasterManager manager = this.getRasterManager(coverageName);
        if (manager != null) {
            manager.removeStore(coverageName, forceDelete, checkForReferences);
            this.rasterManagers.remove(coverageName);
            this.names.remove(coverageName);
            if (this.defaultName == coverageName) {
                Iterator<String> iterator = this.names.iterator();
                this.defaultName = iterator.hasNext() ? iterator.next() : null;
            }
            return true;
        }
        throw new IOException("No Raster manager have been found for the specified coverageName. " + coverageName);
    }

    public GeneralEnvelope getOriginalEnvelope() {
        return this.getOriginalEnvelope(UNSPECIFIED);
    }

    public GeneralEnvelope getOriginalEnvelope(String coverageName) {
        String name = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(name);
        return manager.spatialDomainManager.coverageEnvelope;
    }

    public GridEnvelope getOriginalGridRange() {
        return this.getOriginalGridRange(UNSPECIFIED);
    }

    public GridEnvelope getOriginalGridRange(String coverageName) {
        String name = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(name);
        return manager.spatialDomainManager.gridEnvelope;
    }

    public MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
        return this.getOriginalGridToWorld(UNSPECIFIED, pixInCell);
    }

    public MathTransform getOriginalGridToWorld(String coverageName, PixelInCell pixInCell) {
        String name = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(name);
        return manager.spatialDomainManager.getOriginalGridToWorld(pixInCell);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.getCoordinateReferenceSystem(UNSPECIFIED);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        String name = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(name);
        return manager.spatialDomainManager.coverageCRS;
    }

    public ImageLayout getImageLayout() throws IOException {
        return this.getImageLayout(UNSPECIFIED);
    }

    public ImageLayout getImageLayout(String coverageName) throws IOException {
        String name = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(name);
        return manager.defaultImageLayout;
    }

    public double[][] getResolutionLevels() throws IOException {
        return this.getResolutionLevels(UNSPECIFIED);
    }

    public double[][] getResolutionLevels(String coverageName) throws IOException {
        String name = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(name);
        return manager.levels;
    }

    public List<HarvestedSource> harvest(String defaultCoverage, Object source, Hints hints) throws IOException, UnsupportedOperationException {
        HarvestedResource resource = HarvestedResource.getResourceFromObject(source);
        ArrayList<HarvestedSource> result = new ArrayList<HarvestedSource>();
        if (resource == null) {
            result.add((HarvestedSource)new DefaultHarvestedSource(source, false, "Unrecognized source type"));
            return result;
        }
        if (source instanceof File && !((File)source).exists() || HarvestedResource.FILE_COLLECTION == resource && this.singleFileList(source)) {
            result.add((HarvestedSource)new DefaultHarvestedSource(source, false, "Specified file path does not exist"));
            return result;
        }
        resource.harvest(defaultCoverage, source, hints, result, this);
        String coverage = defaultCoverage != null ? defaultCoverage : this.defaultName;
        RasterManager rasterManager = this.rasterManagers.get(coverage);
        rasterManager.initialize(true);
        return result;
    }

    private boolean singleFileList(Object source) {
        File file;
        Collection collection;
        return source instanceof Collection && (collection = (Collection)source).size() == 1 && !(file = (File)collection.iterator().next()).exists();
    }

    public List<DimensionDescriptor> getDimensionDescriptors(String coverageName) throws IOException {
        if (coverageName == null) {
            coverageName = this.defaultName;
        }
        RasterManager manager = this.getRasterManager(coverageName);
        return manager.getDimensionDescriptors();
    }

    public synchronized void delete(boolean deleteData) throws IOException {
        String[] coverageNames;
        for (String coverageName : coverageNames = this.getGridCoverageNames()) {
            this.removeCoverage(coverageName, deleteData, true);
        }
        this.dispose();
        this.granuleCatalog.drop();
        if (deleteData) {
            File[] list = this.parentDirectory.listFiles();
            if (list != null) {
                for (File file : list) {
                    FileUtils.deleteQuietly((File)file);
                }
            }
        } else {
            this.finalizeCleanup();
        }
    }

    private void finalizeCleanup() {
        IOFileFilter filesFilter = Utils.getCleanupFilter();
        Collection files = FileUtils.listFiles((File)this.parentDirectory, (IOFileFilter)filesFilter, null);
        for (File file : files) {
            FileUtils.deleteQuietly((File)file);
        }
    }

    public ResourceInfo getInfo(String coverageName) {
        String name = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(name);
        String parentLocation = URLs.fileToUrl((File)this.parentDirectory).toString();
        return new ImageMosaicFileResourceInfo(manager, parentLocation, this.locationAttributeName);
    }

    public ServiceInfo getInfo() {
        IOFileFilter filesFilter = Utils.MOSAIC_SUPPORT_FILES_FILTER;
        Collection files = FileUtils.listFiles((File)this.parentDirectory, (IOFileFilter)filesFilter, null);
        ArrayList<FileGroupProvider.FileGroup> fileGroups = new ArrayList<FileGroupProvider.FileGroup>();
        for (File file : files) {
            fileGroups.add(new FileGroupProvider.FileGroup(file, null, null));
        }
        return new DefaultFileServiceInfo(fileGroups);
    }

    public ExecutorService getMultiThreadedLoader() {
        return this.multiThreadedLoader;
    }

    public DatasetLayout getDatasetLayout() {
        return this.getDatasetLayout(this.checkUnspecifiedCoverage(UNSPECIFIED));
    }

    static class ImageMosaicURLCollectionWalker
    extends ImageMosaicWalker
    implements Runnable {
        ImageMosaicURLFeatureConsumer.ImageMosaicURLConsumer imageMosaicUrlConsumer;
        private Collection<URL> urls;

        public ImageMosaicURLCollectionWalker(ImageMosaicConfigHandler configHandler, ImageMosaicEventHandlers eventHandler, URLSourceSPIProvider urlSourceSPIProvider, Collection<URL> urls) {
            super(configHandler, eventHandler);
            this.imageMosaicUrlConsumer = new ImageMosaicURLFeatureConsumer.ImageMosaicURLConsumer(urlSourceSPIProvider);
            this.urls = urls;
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            block28: {
                String message;
                block27: {
                    this.configHandler.indexingPreamble();
                    this.startTransaction();
                    this.setNumElements(this.urls.size());
                    for (URL url : this.urls) {
                        if (this.getStop()) break;
                        if (this.imageMosaicUrlConsumer.checkElement(url, (ImageMosaicWalker)this)) {
                            this.imageMosaicUrlConsumer.handleElement(url, (ImageMosaicWalker)this);
                            continue;
                        }
                        this.skip(url.toString());
                    }
                    if (this.getStop()) {
                        this.rollbackTransaction();
                        break block27;
                    }
                    this.commitTransaction();
                }
                try {
                    this.closeTransaction();
                }
                catch (Exception e) {
                    message = "Unable to close transaction" + e.getLocalizedMessage();
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, message, e);
                    }
                    this.eventHandler.fireException(e);
                }
                try {
                    this.configHandler.indexingPostamble(!this.getStop());
                }
                catch (Exception e) {
                    message = "Unable to close indexing" + e.getLocalizedMessage();
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, message, e);
                    }
                    this.eventHandler.fireException(e);
                }
                break block28;
                catch (IOException e) {
                    String message2;
                    try {
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                        try {
                            this.rollbackTransaction();
                        }
                        catch (IOException e1) {
                            throw new IllegalStateException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        String message3;
                        try {
                            this.closeTransaction();
                        }
                        catch (Exception e2) {
                            message3 = "Unable to close transaction" + e2.getLocalizedMessage();
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, message3, e2);
                            }
                            this.eventHandler.fireException(e2);
                        }
                        try {
                            this.configHandler.indexingPostamble(!this.getStop());
                        }
                        catch (Exception e3) {
                            message3 = "Unable to close indexing" + e3.getLocalizedMessage();
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, message3, e3);
                            }
                            this.eventHandler.fireException(e3);
                        }
                        throw throwable;
                    }
                    try {
                        this.closeTransaction();
                    }
                    catch (Exception e4) {
                        message2 = "Unable to close transaction" + e4.getLocalizedMessage();
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, message2, e4);
                        }
                        this.eventHandler.fireException(e4);
                    }
                    try {
                        this.configHandler.indexingPostamble(!this.getStop());
                    }
                    catch (Exception e5) {
                        message2 = "Unable to close indexing" + e5.getLocalizedMessage();
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, message2, e5);
                        }
                        this.eventHandler.fireException(e5);
                    }
                }
            }
        }
    }

    static class ImageMosaicFileCollectionWalker
    extends ImageMosaicWalker
    implements Runnable {
        ImageMosaicFileFeatureConsumer.ImageMosaicFileConsumer imageMosaicFileConsumer = new ImageMosaicFileFeatureConsumer.ImageMosaicFileConsumer();
        private Collection<File> files;

        public ImageMosaicFileCollectionWalker(ImageMosaicConfigHandler configHandler, ImageMosaicEventHandlers eventHandler, Collection<File> files) {
            super(configHandler, eventHandler);
            this.files = files;
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            block28: {
                String message;
                block27: {
                    this.configHandler.indexingPreamble();
                    this.startTransaction();
                    this.setNumElements(this.files.size());
                    for (File file : this.files) {
                        if (this.getStop()) break;
                        if (this.imageMosaicFileConsumer.checkElement(file, (ImageMosaicWalker)this)) {
                            this.imageMosaicFileConsumer.handleElement(file, (ImageMosaicWalker)this);
                            continue;
                        }
                        this.skip(file.getAbsolutePath());
                    }
                    if (this.getStop()) {
                        this.rollbackTransaction();
                        break block27;
                    }
                    this.commitTransaction();
                }
                try {
                    this.closeTransaction();
                }
                catch (Exception e) {
                    message = "Unable to close transaction" + e.getLocalizedMessage();
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, message, e);
                    }
                    this.eventHandler.fireException(e);
                }
                try {
                    this.configHandler.indexingPostamble(!this.getStop());
                }
                catch (Exception e) {
                    message = "Unable to close indexing" + e.getLocalizedMessage();
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, message, e);
                    }
                    this.eventHandler.fireException(e);
                }
                break block28;
                catch (IOException e) {
                    String message2;
                    try {
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                        try {
                            this.rollbackTransaction();
                        }
                        catch (IOException e1) {
                            throw new IllegalStateException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        String message3;
                        try {
                            this.closeTransaction();
                        }
                        catch (Exception e2) {
                            message3 = "Unable to close transaction" + e2.getLocalizedMessage();
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, message3, e2);
                            }
                            this.eventHandler.fireException(e2);
                        }
                        try {
                            this.configHandler.indexingPostamble(!this.getStop());
                        }
                        catch (Exception e3) {
                            message3 = "Unable to close indexing" + e3.getLocalizedMessage();
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, message3, e3);
                            }
                            this.eventHandler.fireException(e3);
                        }
                        throw throwable;
                    }
                    try {
                        this.closeTransaction();
                    }
                    catch (Exception e4) {
                        message2 = "Unable to close transaction" + e4.getLocalizedMessage();
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, message2, e4);
                        }
                        this.eventHandler.fireException(e4);
                    }
                    try {
                        this.configHandler.indexingPostamble(!this.getStop());
                    }
                    catch (Exception e5) {
                        message2 = "Unable to close indexing" + e5.getLocalizedMessage();
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, message2, e5);
                        }
                        this.eventHandler.fireException(e5);
                    }
                }
            }
        }
    }
}

